/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.WebContainer;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.virgo.kernel.equinox.extensions.hooks.PluggableDelegatingClassLoaderDelegateHook;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.web.core.WebApplicationRegistry;
import org.eclipse.virgo.web.core.internal.WebAppClassLoaderDelegateHook;
import org.eclipse.virgo.web.core.internal.WebDeploymentEnvironment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

final class WebBundleLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private static final String EMPTY_CONTEXT_PATH = "";
    private static final String ROOT_CONTEXT_PATH = "/";
    private final Map<InstallArtifact, WebApplication> webApplications = new ConcurrentHashMap<InstallArtifact, WebApplication>();
    private final Map<Bundle, BundleInstallArtifact> webBundleInstallArtifacts = new ConcurrentHashMap<Bundle, BundleInstallArtifact>();
    private final WebAppClassLoaderDelegateHook classLoaderDelegateHook = new WebAppClassLoaderDelegateHook();
    private final EventHandler webBundleDeployedEventHandler = new WebBundleDeployedEventHandler();
    private final WebDeploymentEnvironment environment;
    private final BundleContext bundleContext;
    private volatile ServiceRegistration<EventHandler> eventHandlerRegistration;

    WebBundleLifecycleListener(WebDeploymentEnvironment environment, BundleContext bundleContext) {
        this.environment = environment;
        this.bundleContext = bundleContext;
    }

    public void init() {
        PluggableDelegatingClassLoaderDelegateHook.getInstance().addDelegate((ClassLoaderDelegateHook)this.classLoaderDelegateHook);
        this.registerEventHandler();
    }

    private void registerEventHandler() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/osgi/service/web/DEPLOYED");
        this.eventHandlerRegistration = this.bundleContext.registerService(EventHandler.class, (Object)this.webBundleDeployedEventHandler, properties);
    }

    public void destroy() {
        PluggableDelegatingClassLoaderDelegateHook.getInstance().removeDelegate((ClassLoaderDelegateHook)this.classLoaderDelegateHook);
        this.unregisterEventHandler();
    }

    private void unregisterEventHandler() {
        ServiceRegistration<EventHandler> localRegistration = this.eventHandlerRegistration;
        if (localRegistration != null) {
            this.eventHandlerRegistration = null;
            localRegistration.unregister();
        }
    }

    public void onStarting(InstallArtifact installArtifact) throws DeploymentException {
        if (WebBundleLifecycleListener.isWebBundle(installArtifact)) {
            try {
                this.webApplications.put(installArtifact, this.getWebContainer().createWebApplication(((BundleInstallArtifact)installArtifact).getBundle()));
            }
            catch (BundleException be) {
                throw new DeploymentException("Failed to create new web application for web bundle '" + installArtifact + "'.", (Throwable)be);
            }
        }
    }

    public void onStarted(InstallArtifact installArtifact) throws DeploymentException {
        WebApplication webApplication = this.webApplications.get(installArtifact);
        if (webApplication != null) {
            BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
            Bundle bundle = bundleInstallArtifact.getBundle();
            this.webBundleInstallArtifacts.put(bundle, bundleInstallArtifact);
            try {
                webApplication.start();
                this.classLoaderDelegateHook.addWebApplication(webApplication, bundle);
                String contextPath = this.getContextPath(webApplication);
                this.getApplicationRegistry().registerWebApplication(contextPath, this.getApplicationName(installArtifact));
                installArtifact.setProperty("org.eclipse.virgo.web.contextPath", contextPath);
                installArtifact.setProperty("artifact-type", "Web Bundle");
            }
            catch (WebApplicationStartFailedException wasfe) {
                throw new DeploymentException("Web application failed to start", (Throwable)wasfe);
            }
        }
    }

    protected void webBundleDeployed(Bundle webBundle) {
        BundleInstallArtifact installArtifact = this.webBundleInstallArtifacts.get(webBundle);
        if (installArtifact != null) {
            WebApplication webApplication = this.webApplications.get(installArtifact);
        }
    }

    public void onStopping(InstallArtifact installArtifact) {
        WebApplication webApplication = this.webApplications.remove(installArtifact);
        if (webApplication != null) {
            BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
            Bundle bundle = bundleInstallArtifact.getBundle();
            this.getApplicationRegistry().unregisterWebApplication(this.getContextPath(webApplication));
            this.classLoaderDelegateHook.removeWebApplication(bundle);
            webApplication.stop();
            this.webBundleInstallArtifacts.remove(((BundleInstallArtifact)installArtifact).getBundle());
        }
    }

    private static boolean isWebBundle(InstallArtifact installArtifact) throws DeploymentException {
        if (installArtifact instanceof BundleInstallArtifact) {
            try {
                BundleManifest bundleManifest = ((BundleInstallArtifact)installArtifact).getBundleManifest();
                return "web-bundle".equals(bundleManifest.getModuleType());
            }
            catch (IOException ioe) {
                throw new DeploymentException("Failed to get bundle manifest from '" + installArtifact + "'", (Throwable)ioe);
            }
        }
        return false;
    }

    private String getContextPath(WebApplication webApplication) {
        String contextPath = webApplication.getServletContext().getContextPath();
        if (EMPTY_CONTEXT_PATH.equals(contextPath)) {
            return ROOT_CONTEXT_PATH;
        }
        return contextPath;
    }

    private WebContainer getWebContainer() {
        return this.environment.getWebContainer();
    }

    private WebApplicationRegistry getApplicationRegistry() {
        return this.environment.getApplicationRegistry();
    }

    private String getApplicationName(InstallArtifact installArtifact) {
        return String.valueOf(installArtifact.getName()) + "-" + installArtifact.getVersion();
    }

    private final class WebBundleDeployedEventHandler
    implements EventHandler {
        private WebBundleDeployedEventHandler() {
        }

        public void handleEvent(Event event) {
            if ("org/osgi/service/web/DEPLOYED".equals(event.getTopic())) {
                WebBundleLifecycleListener.this.webBundleDeployed((Bundle)event.getProperty("bundle"));
            }
        }
    }
}

