/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.net.URI;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.internal.event.DeploymentListener;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListener;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;

final class StateCleanupInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport
implements InstallArtifactLifecycleListener {
    private final DeploymentListener deploymentListener;
    private final RuntimeArtifactModel runtimeArtifactModel;

    StateCleanupInstallArtifactLifecycleListener(DeploymentListener deploymentListener, RuntimeArtifactModel runtimeArtifactModel) {
        this.deploymentListener = deploymentListener;
        this.runtimeArtifactModel = runtimeArtifactModel;
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
        URI location = this.runtimeArtifactModel.getLocation(deploymentIdentity);
        if (location != null) {
            this.deploymentListener.undeployed(location);
            this.runtimeArtifactModel.delete(deploymentIdentity);
        }
    }
}

