/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.cacheing.CacheingArtifactDescriptor;
import org.eclipse.virgo.repository.internal.cacheing.cache.RepositoryCache;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

final class CacheingQuery
implements Query {
    private final Query delegate;
    private final RepositoryCache cache;

    public CacheingQuery(Query delegate, RepositoryCache cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public Query addFilter(String name, String value) {
        this.delegate.addFilter(name, value);
        return this;
    }

    @Override
    public Query addFilter(String name, String value, Map<String, Set<String>> properties) {
        this.delegate.addFilter(name, value, properties);
        return this;
    }

    @Override
    public Query setVersionRangeFilter(VersionRange versionRange) {
        this.delegate.setVersionRangeFilter(versionRange);
        return this;
    }

    @Override
    public Query setVersionRangeFilter(VersionRange versionRange, Query.VersionRangeMatchingStrategy strategy) {
        this.delegate.setVersionRangeFilter(versionRange, strategy);
        return this;
    }

    @Override
    public Set<RepositoryAwareArtifactDescriptor> run() {
        Set<RepositoryAwareArtifactDescriptor> descriptors = this.delegate.run();
        HashSet<CacheingArtifactDescriptor> cacheingDescriptors = new HashSet<CacheingArtifactDescriptor>(descriptors.size());
        for (RepositoryAwareArtifactDescriptor descriptor : descriptors) {
            cacheingDescriptors.add(new CacheingArtifactDescriptor(descriptor, this.cache));
        }
        return Collections.unmodifiableSet(cacheingDescriptors);
    }
}

