/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.transport.smtp;

import org.apache.geronimo.javamail.transport.smtp.MalformedSMTPReplyException;

class SMTPReply {
    private final String reply;
    private final int code;
    private final String message;
    private boolean continued;

    SMTPReply(String s) throws MalformedSMTPReplyException {
        this.reply = s;
        if (s == null || s.length() < 3) {
            this.code = -1;
            this.message = s;
            return;
        }
        try {
            this.continued = false;
            this.code = Integer.parseInt(s.substring(0, 3));
            if (s.length() > 4) {
                if (s.charAt(3) == '-') {
                    this.continued = true;
                }
                this.message = s.substring(4);
            } else {
                this.message = "";
            }
        }
        catch (NumberFormatException e) {
            throw new MalformedSMTPReplyException("error in parsing code", e);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReply() {
        return this.reply;
    }

    boolean isError() {
        return this.code >= 400;
    }

    public boolean isContinued() {
        return this.continued;
    }

    public String toString() {
        return "CODE = " + this.getCode() + " : MSG = " + this.getMessage();
    }
}

