/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding;
import org.eclipse.swt.widgets.Widget;

public abstract class EmfAbstractBinding
implements Adapter,
IEmfWidgetBinding {
    protected AdapterFactory adapterFactory;
    protected EObject notifier;
    protected int featureId;
    protected IItemPropertyDescriptor item;
    protected Collection choices;
    static /* synthetic */ Class class$0;

    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        this.adapterFactory = adapterFactory;
        this.featureId = featureId;
    }

    public void setEObject(EObject notifier) {
        this.uninstallListeners();
        try {
            this.notifier = notifier;
            this.setValuesFromModel();
        }
        finally {
            this.installListeners();
        }
    }

    protected void installListeners() {
        if (this.notifier != null) {
            this.notifier.eAdapters().add((Object)this);
        }
    }

    protected void uninstallListeners() {
        if (this.notifier != null) {
            while (this.notifier.eAdapters().remove((Object)this)) {
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8) {
            return;
        }
        this.uninstallListeners();
        try {
            this.setValuesFromModel();
        }
        finally {
            this.installListeners();
        }
    }

    private void setValuesFromModel() {
        AdapterFactoryItemDelegator contentProvider = new AdapterFactoryItemDelegator(this.adapterFactory);
        EStructuralFeature feature = (EStructuralFeature)this.notifier.eClass().getEAllStructuralFeatures().get(this.featureId);
        for (IItemPropertyDescriptor itemPropertyDescriptor : contentProvider.getPropertyDescriptors((Object)this.notifier)) {
            if (!feature.equals(itemPropertyDescriptor.getFeature((Object)this.notifier))) continue;
            this.item = itemPropertyDescriptor;
            break;
        }
        if (this.item != null) {
            IItemLabelProvider labelProvider = this.item.getLabelProvider((Object)this.notifier);
            Collection choices = this.getChoiceValuesFromModel(this.item, this.notifier);
            if (choices != null) {
                this.setChoicesFromModel(labelProvider, choices);
            }
            this.setValueFromModel(labelProvider, this.getValueFromModel(this.notifier, feature));
        }
    }

    protected Object getValueFromModel(EObject notifier, EStructuralFeature feature) {
        return notifier.eGet(feature);
    }

    protected Collection getChoiceValuesFromModel(IItemPropertyDescriptor item, EObject notifier) {
        return item.getChoiceOfValues((Object)notifier);
    }

    protected Object getCurrentValueFromModel() {
        new AdapterFactoryItemDelegator(this.adapterFactory);
        EStructuralFeature feature = (EStructuralFeature)this.notifier.eClass().getEAllStructuralFeatures().get(this.featureId);
        return this.notifier.eGet(feature);
    }

    protected void setValuesFromWidget(final Object value) {
        new AdapterFactoryItemDelegator(this.adapterFactory);
        final EStructuralFeature feature = (EStructuralFeature)this.notifier.eClass().getEAllStructuralFeatures().get(this.featureId);
        this.setValuesFromWidget(new Runnable(){

            public void run() {
                EmfAbstractBinding.this.notifier.eSet(feature, value);
            }
        });
    }

    protected void setValuesFromWidget(Runnable r) {
        try {
            this.uninstallListeners();
            MetadataElement amd = (MetadataElement)this.getTarget();
            IEntityModelManager mm = (IEntityModelManager)amd.adapt(IEntityModelManager.class);
            if (mm != null) {
                mm.executeModelChanges(r);
            } else {
                r.run();
            }
        }
        finally {
            this.installListeners();
        }
    }

    protected abstract void setChoicesFromModel(IItemLabelProvider var1, Collection var2);

    protected abstract void setValueFromModel(IItemLabelProvider var1, Object var2);

    public Notifier getTarget() {
        return this.notifier;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return this.notifier != null && type instanceof Class && this.notifier.getClass().isAssignableFrom((Class)type);
    }
}

