/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.Transient;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

public abstract class AttributeIO
implements IAdapterFactory {
    protected final EntityIO entityIO;
    public static final IntOption MAPPING_NOT_PERSISTENT = new IntOption(0, "Not persistent", "Attribute is not stored in the database", Utils.getImage("NotPersistent16"));
    protected static final CascadeType[] CASCADE_TYPE_ALL = new CascadeType[]{CascadeType.ALL};
    public static final int RELATIVE_POSITION_FACTOR = 100;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AttributeIO(EntityIO entityIO) {
        this.entityIO = entityIO;
    }

    public static AttributeIO get(AttributeMetaData amd) {
        return (AttributeIO)amd.adapt(AttributeIO.class);
    }

    public void dispose() {
    }

    public abstract boolean updateModelFromMetaData(RClass var1, RAnnotatedElement var2, boolean var3);

    public boolean updateMetaDataFromModel(RClass cls, boolean accessChanged) {
        AttributeMetaData amd = this.getAttributeMetaData();
        RAnnotatedElement attribute = amd.isField() ? cls.getDeclaredField(amd.getName()) : cls.getDeclaredMethod(amd.getGetterMethodName());
        RAnnotatedElement newAttr = null;
        if (accessChanged) {
            if (amd.isField()) {
                String s = amd.getName();
                String methodName = "get" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
                newAttr = cls.getDeclaredMethod(methodName);
                if (newAttr != null) {
                    amd.setGetterMethodName(methodName);
                }
            } else {
                newAttr = cls.getDeclaredField(amd.getName());
                if (newAttr != null) {
                    amd.setGetterMethodName(null);
                }
            }
            if (newAttr != null) {
                Annotation[] all = newAttr.getAnnotations();
                if (all.length > 1 || all.length == 1 && all[0].annotationType() != Transient.class) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.updateMetaDataFromModel(cls, newAttr == null ? attribute : newAttr);
        if (newAttr != null) {
            Annotation[] annotationArray = attribute.getAnnotations();
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation ann = annotationArray[n];
                AnnotationEx a = (AnnotationEx)((Object)ann);
                if (a.getErrorMap() == null) {
                    a.delete();
                }
                ++n;
            }
        }
        return true;
    }

    protected abstract void updateMetaDataFromModel(RClass var1, RAnnotatedElement var2);

    public abstract AttributeMetaData getAttributeMetaData();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return this;
    }

    public Class[] getAdapterList() {
        return new Class[]{AttributeIO.class};
    }

    public abstract void getPossibleMappings(List var1);

    public abstract IntOption getMapping();

    public abstract void setMapping(IntOption var1);

    protected void setFetchType(AttributeMetaData amd, FetchType ft) {
        switch (ft) {
            case LAZY: {
                amd.setFetchType(2);
                break;
            }
            default: {
                amd.setFetchType(1);
            }
        }
    }

    protected FetchType getFetchType(AttributeMetaData amd) {
        switch (amd.getFetchType()) {
            case 1: {
                return FetchType.EAGER;
            }
            case 2: {
                return FetchType.LAZY;
            }
        }
        return null;
    }

    public GenericEntityModelManager getModelManager() {
        return this.entityIO.getModelManager();
    }

    protected AttributeMetaData initAttributeMetaData(AttributeMetaData amd, RAnnotatedElement attribute, EClass eClass) {
        boolean isNewAttribute;
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        boolean bl = isNewAttribute = amd == null;
        if (isNewAttribute) {
            GenericEntityModelManager mm = this.entityIO.getModelManager();
            amd = (AttributeMetaData)mm.getFactory().create(eClass);
            amd.setName(Utils.getAttributeName(attribute));
            amd.registerAdapterFactory((IAdapterFactory)this);
            amd.eAdapters().add((Object)this.entityIO);
            if (attribute.isField()) {
                amd.setGetterMethodName(null);
            } else {
                amd.setGetterMethodName(attribute.getName());
            }
        }
        boolean persistent = attribute.isAnnotationPresent(Transient.class) ? false : (attribute.isField() ? emd.getAccessType() == 1 : emd.getAccessType() == 2);
        this.setPersistent(amd, persistent, isNewAttribute);
        TypeMetaData tmd = this.entityIO.findTypeByClassName(attribute.getTypeName());
        if (tmd == null) {
            if (attribute.isTypeEnum()) {
                tmd = this.entityIO.findTypeByClassName("java.lang.Enum");
            } else if (attribute.isTypeSerializable()) {
                tmd = this.entityIO.findTypeByClassName("java.io.Serializable");
            }
        }
        amd.setJavaType(tmd);
        return amd;
    }

    protected void setPersistent(boolean persistent) {
        this.setPersistent(this.getAttributeMetaData(), persistent, false);
    }

    protected void setPersistent(AttributeMetaData amd, boolean persistent, boolean isNewAttribute) {
        if (persistent) {
            if (isNewAttribute || amd.isNonPersistent()) {
                this.entityIO.removeNonPersistentAttribute(amd);
                this.entityIO.getEntityMetaData().getAttributeList().add((Object)amd);
            }
        } else if (isNewAttribute || !amd.isNonPersistent()) {
            amd.makeNonPersistent();
            this.entityIO.addNonPersistentAttribute(amd);
        }
    }

    protected String getComment(AttributeMetaData amd) {
        return String.valueOf(amd.getEntityMetaData().getSchemaName()) + "." + amd.getName();
    }

    public EntityIO getEntityIO() {
        return this.entityIO;
    }

    public void ensureTransient(RAnnotatedElement attribute) {
        if (this.entityIO.isPersistentByDefault(attribute)) {
            AnnotationEx t = (AnnotationEx)attribute.getAnnotation(Transient.class, true);
            t.setMarker(true);
        }
    }

    protected boolean hasTableAndPrimaryKey(EntityMetaData target) {
        if (target == null || target.getTable() == null || EntityIO.get(target).getModelUpdateStatus() < 2) {
            return false;
        }
        return !target.getTable().getPrimaryKeyList().isEmpty();
    }

    protected AttributeMetaData getMappedByAttribute(AnnotationEx main, String mappedBy, EntityMetaData target) {
        AttributeMetaData ans;
        EntityIO targetEntityIO = EntityIO.get(target);
        String newName = targetEntityIO.getNewAttributeName(mappedBy);
        if (newName != null) {
            this.entityIO.getModelManager().registerForMetaDataUpdate(this.entityIO);
            mappedBy = newName;
        }
        if ((ans = target.findAttributeMetaData(mappedBy)) == null) {
            this.entityIO.addProblem("Attribute '" + mappedBy + "' not found on " + target.getClassName(), main.getLocation("mappedBy"));
        } else if (ans.getMappedBy() != null) {
            this.entityIO.addProblem("Attribute '" + mappedBy + "' also has mappedBy set", main.getLocation("mappedBy"));
            ans = null;
        }
        return ans;
    }

    protected int getCascadeBits(CascadeType[] cascade) {
        int bits = 0;
        int i = 0;
        while (i < cascade.length) {
            bits |= this.getCascadeBits(cascade[i]);
            ++i;
        }
        return bits;
    }

    protected int getCascadeBits(CascadeType ct) {
        switch (ct) {
            case ALL: {
                return 15;
            }
            case MERGE: {
                return 2;
            }
            case PERSIST: {
                return 1;
            }
            case REFRESH: {
                return 8;
            }
            case REMOVE: {
                return 4;
            }
        }
        return 0;
    }

    protected CascadeType[] getCascadeTypes(int bits) {
        if (bits == 0) {
            return null;
        }
        if ((bits & 0xF) == 15) {
            return CASCADE_TYPE_ALL;
        }
        ArrayList<CascadeType> ans = new ArrayList<CascadeType>(3);
        if ((bits & 1) != 0) {
            ans.add(CascadeType.PERSIST);
        }
        if ((bits & 2) != 0) {
            ans.add(CascadeType.MERGE);
        }
        if ((bits & 4) != 0) {
            ans.add(CascadeType.REMOVE);
        }
        if ((bits & 8) != 0) {
            ans.add(CascadeType.REFRESH);
        }
        CascadeType[] a = new CascadeType[ans.size()];
        ans.toArray(a);
        return a;
    }

    public List getValidMappedByAttributes() {
        return Collections.EMPTY_LIST;
    }

    public int getRelativePosition(RAnnotatedElement attribute) {
        return this.entityIO.getRelativePosition() + attribute.getRelativeIndexInOwner() * 100;
    }

    public String getTypeName(EntityMetaData target) {
        switch (target.getEntityType()) {
            default: {
                return "Entity";
            }
            case 2: {
                return "Embeddable";
            }
            case 3: 
        }
        return "EmbeddableSuperclass";
    }

    protected void addNullJavaTypeProblem(RAnnotatedElement attribute) {
        String typeName = attribute.getTypeName();
        if (typeName != null) {
            this.entityIO.addProblem(String.valueOf(typeName) + " is not persistent", attribute.getLocation());
        }
    }
}

