/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.ast.AstRAnnotatedElement;
import org.eclipse.jsr220orm.generic.io.ast.AstRClass;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RMethod;

public class AstRMethod
extends AstRAnnotatedElement
implements RMethod {
    protected final AstRClass cls;
    protected final MethodDeclaration declaration;
    protected final ITypeBinding binding;

    public AstRMethod(AstRClass cls, MethodDeclaration declaration, int relativeIndexInOwner) {
        super(cls.getFactory(), declaration.modifiers(), cls.getImportListHelper(), relativeIndexInOwner);
        this.cls = cls;
        this.declaration = declaration;
        Type rt = declaration.getReturnType2();
        this.binding = rt == null ? null : rt.resolveBinding();
        this.initAnnotations();
    }

    public String getName() {
        return this.declaration.getName().getFullyQualifiedName();
    }

    public String toString() {
        return this.getName();
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.cls.getFullyQualifiedName()) + "." + this.getName();
    }

    public String getTypeName() {
        return Utils.getTypeName(this.binding);
    }

    public boolean isField() {
        return false;
    }

    public Map getLocation() {
        return Utils.createMarkerLocation((ASTNode)this.declaration.getName());
    }

    public RClass getRClass() {
        return this.cls;
    }

    public String[] getActualTypeArguments() {
        if (this.binding == null) {
            return null;
        }
        ITypeBinding[] ta = this.binding.getTypeArguments();
        int n = ta.length;
        if (n == 0) {
            return null;
        }
        String[] ans = new String[n];
        int i = 0;
        while (i < n) {
            ans[i] = Utils.getTypeName(ta[i]);
            ++i;
        }
        return ans;
    }

    public boolean hasNoParameters() {
        return this.declaration.parameters().isEmpty();
    }
}

