/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.nature;

/**
 * The listener interface for receiving events when a ORM nature changes.
 */
public interface OrmNatureListener {
	/**
	 * The ORM product have been activated.
	 */
	void projectActivated(OrmNatureEvent e);

	/**
     * The ORM product have been deactivated.
	 */
	void projectDeactivated(OrmNatureEvent e);

    /**
     * The project not longer has a ORM nature and all products are deactivated.
     */
    void ormNatureRemoved(OrmNatureEvent e);
}
