/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import java.util.HashSet;
import java.util.List;

import org.eclipse.emf.common.util.EList;

/**
 * A persistent attribute (e.g. field, property) of an entity.
 * 
 * @model abstract="true"
 * @generated
 */
public interface AttributeMetaData extends MetadataElement{

	/**
	 * Attribute is a field of the entity.
	 */
	public static final int ACCESS_TYPE_FIELD = 1;

	/**
	 * Attribute is a Javabean style property (get and set methods).
	 */
	public static final int ACCESS_TYPE_PROPERTY = 2;

	/**
	 * Fetch attribute when object is read.
	 */
	public static final int FETCH_TYPE_EAGER = 1;

	/**
	 * Fetch attribute when it is first touched.
	 */
	public static final int FETCH_TYPE_LAZY = 2;

	/**
	 * Do not cascade any operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_NONE = 0;

	/**
	 * Cascade persist operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_PERSIST = 1;

	/**
	 * Cascade merge operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_MERGE = 2;

	/**
	 * Cascade remove operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_REMOVE = 4;

	/**
	 * Cascade refresh operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_REFRESH = 8;

	/**
	 * Cascade all operations to the associated entity.
	 */
	public static final int CASCADE_TYPE_ALL = 15;

	/**
	 * Get the entity we belong to. It is bidirectional and its opposite 
	 * is '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getAttributeList <em>Attribute List</em>}'.
	 * This is null if {@link #getEmbeddedIn()} is not null.
	 * 
	 * @model opposite="attributeList"
	 * @generated
	 */
	EntityMetaData getEntityMetaData();

    void setEntityMetaData(EntityMetaData value);

	/**
	 * If we are an attribute belonging to an embedded type then this is
	 * that attribute (see {@link EmbeddedAttribute#getAttributeList()}).
	 * Note that {@link #getEntityMetaData()} will be null in this case.
	 * 
	 * @model opposite="attributeList"
	 * @generated
	 */
	EmbeddedAttribute getEmbeddedIn();

	void setEmbeddedIn(EmbeddedAttribute value);

	/**
	 * Get the name of this attribute.
	 * 
	 * @model
	 * @generated
	 */
	String getName();

	void setName(String value);

	/**
	 * Get the type of this attribute.
	 * 
	 * @model
	 * @generated
	 */
	TypeMetaData getJavaType();

    void setJavaType(TypeMetaData value);

	/**
	 * Must this field be fetched eagerly or lazily (see
	 * {@link #FETCH_TYPE_EAGER} etc.)?
	 * 
	 * @model
	 * @generated
	 */
	int getFetchType();

	void setFetchType(int value);

	/**
	 * May the value of this attribute be null?
	 * 
	 * @model
	 * @generated
	 */
	boolean isOptional();

	void setOptional(boolean value);

	/**
	 * For property attributes this is the name of the get method. For field
	 * attributes it is null.
	 * 
	 * @model
	 * @generated
	 */
    String getGetterMethodName();

    void setGetterMethodName(String value);

	/**
	 * For property attributes this is the name of the set method (if any).
	 * For field attributes it is null.
	 * 
	 * @model
	 * @generated
	 */
    String getSetterMethodName();

    void setSetterMethodName(String value);

	/**
	 * For bidirectional attributes this is the attribute that owns the 
	 * mapping.
	 * 
	 * @model opposite="inverseList"
	 * @generated
	 */
	AttributeMetaData getMappedBy();

	void setMappedBy(AttributeMetaData value);

	/**
	 * All the attributes that have us set as their {@link #getMappedBy()}
	 * attribute.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.AttributeMetaData" opposite="mappedBy"
	 * @generated
	 */
	EList getInverseList();

	/**
	 * For attributes that override an attribute belonging to another class
	 * (e.g. an embeddable superclass or embedded mapping) this is the 
	 * attribute being overridden.
	 * 
	 * @see #getOverrideList
	 * 
	 * @model opposite="overrideList"
	 * @generated
	 */
	AttributeMetaData getOverrideOf();

	void setOverrideOf(AttributeMetaData value);

	/**
	 * Return all the attributes that override us (i.e. have us as their
	 * {@link #getOverrideOf()}).
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.AttributeMetaData" opposite="overrideOf"
	 * @generated
	 */
	EList getOverrideList();

	/**
	 * Is this attribute in the {@link EntityMetaData#getPrimaryKeyList()}
	 * of its entity?
	 * 
	 * @model kind="operation"
	 */
	boolean isPrimaryKey();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	boolean isVersion();

	/**
	 * Is this a non-persistent attribute?
	 * 
	 * @model kind="operation"
	 */
	boolean isNonPersistent();

	/**
	 * Remove this attribute and all of its owned objects (e.g. OrmColumn's)
	 * from the model. 
	 * This is similar to {@link #delete()} but does not clear adapters.
	 * 
	 * @model
	 */
	void makeNonPersistent();

	/**
	 * Is this attribute for a field (i.e. not a property).
	 * 
	 * @model kind="operation"
	 */
	boolean isField();

    /**
     * Allthe columns that are relevant to this attribute
     */
    List getColumns();

	/**
	 * Remove this attribute and all of its owned objects (e.g. OrmColumn's)
	 * from the model. This also clears the adapters.
	 * 
	 * @see #makeNonPersistent()
	 * 
	 * @model
	 */
	void delete();

    void getTopLevelSqlObjects(HashSet sqlObjects);

} // AttributeMetaData
