/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;


/**
 * Part of a {@link Join} linking two columns together.
 * 
 * @model
 * @generated
 */
public interface JoinPair extends MetadataElement {

	/**
	 * The {@link Join} this Pair is part of.
	 * 
	 * @model
	 * @generated
	 */
	Join getJoin();

	/**
	 * @generated
	 */
	void setJoin(Join value);

	/**
	 * The column for the table this join is from e.g. the primary key of the
	 * main table for an entity.
	 * 
	 * @model
	 * @generated
	 */
	OrmColumn getSrc();

	/**
	 * @generated
	 */
	void setSrc(OrmColumn value);

	/**
	 * The column in the table this join is to e.g. the primary key of a
	 * secondary table for an entity.
	 * 
	 * @model
	 * @generated
	 */
	OrmColumn getDest();

	/**
	 * @generated
	 */
	void setDest(OrmColumn value);

}
