/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.io.ast;

import java.util.HashMap;
import java.util.Map;

/**
 * This maintains state information from the processing of an AST tree that
 * may need to be used for future parsing of the same source. Example:
 * Errors associated with annotation values need to be remembered so we
 * can avoid setting those values in response to model changes.
 */
public class AstState {

	protected Map <AnnKey, Map<String, String>> annErrorMaps = new HashMap();
	
	public AstState() {
	}
	
	/**
	 * Get the error map for the annotation. If create is true then a new one
	 * is created if none found. Otherwise null is returned. 
	 */
	public Map<String, String> getAnnotationErrorMap(
			AstAnnotationProxyHandler proxy, boolean create) {
		AnnKey key = new AnnKey(proxy);
		Map map = annErrorMaps.get(key);
		if (create && map == null) {
			annErrorMaps.put(key, map = new HashMap());			
		}
		return map;
	}
	
	/**
	 * Uniquely identifies an annotation.
	 */
	protected static class AnnKey {
		
		public String annotationOwner;
		public Class annotationType;
		
		public AnnKey(AstAnnotationProxyHandler proxy) {
			annotationOwner = proxy.getOwner().getFullyQualifiedName();
			annotationType = proxy.getAnnotationType();
		}

		public boolean equals(Object o) {
			AnnKey k = (AnnKey)o;
			return k.annotationType == annotationType 
					&& k.annotationOwner.equals(annotationOwner);
		}

		public int hashCode() {
			return annotationType.hashCode() + 29 * annotationOwner.hashCode();
		}

		public String toString() {
			return annotationOwner + "/" + annotationType.getName();
		}
	}
	
}
