/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributeMetaDataItemProvider.java,v 1.16 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * This is the item provider adapter for a {@link org.eclipse.jsr220orm.metadata.AttributeMetaData} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AttributeMetaDataItemProvider
  extends MetadataElementItemProvider
  implements	
    IEditingDomainItemProvider,	
    IStructuredItemContentProvider,	
    ITreeItemContentProvider,	
    IItemLabelProvider,	
    IItemPropertySource		
{
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public AttributeMetaDataItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addEmbeddedInPropertyDescriptor(object);
			addNamePropertyDescriptor(object);
			addJavaTypePropertyDescriptor(object);
			addFetchTypePropertyDescriptor(object);
			addOptionalPropertyDescriptor(object);
			addGetterMethodNamePropertyDescriptor(object);
			addSetterMethodNamePropertyDescriptor(object);
			addMappedByPropertyDescriptor(object);
			addInverseListPropertyDescriptor(object);
			addOverrideOfPropertyDescriptor(object);
			addOverrideListPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Embedded In feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addEmbeddedInPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_embeddedIn_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_embeddedIn_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_EmbeddedIn(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_name_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_name_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Java Type feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addJavaTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_javaType_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_javaType_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_JavaType(),
				 true,
				 null,
				 null,
				 null));
	}

    /**
     * This adds a property descriptor for the Fetch Type feature.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     */
  protected void addFetchTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (new IntOptionDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_AttributeMetaData_fetchType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_fetchType_feature", "_UI_AttributeMetaData_type"),
                 MetadataPackage.eINSTANCE.getAttributeMetaData_FetchType(),
                 true,
                 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
	 * This adds a property descriptor for the Optional feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addOptionalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_optional_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_optional_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_Optional(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Getter Method Name feature.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected void addGetterMethodNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_getterMethodName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_getterMethodName_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_GetterMethodName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Setter Method Name feature.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected void addSetterMethodNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_setterMethodName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_setterMethodName_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_SetterMethodName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Mapped By feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addMappedByPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_mappedBy_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_mappedBy_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_MappedBy(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Inverse List feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInverseListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_inverseList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_inverseList_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_InverseList(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Override Of feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOverrideOfPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_overrideOf_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_overrideOf_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_OverrideOf(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Override List feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOverrideListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AttributeMetaData_overrideList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AttributeMetaData_overrideList_feature", "_UI_AttributeMetaData_type"),
				 MetadataPackage.eINSTANCE.getAttributeMetaData_OverrideList(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MetadataPackage.eINSTANCE.getAttributeMetaData_EntityMetaData());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getAttributeMetaData_MappedBy());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	public String getText(Object object) {
	  	AttributeMetaData amd = (AttributeMetaData)object;
		StringBuffer s = new StringBuffer();
		s.append(amd.getName());
		s.append(" : ");
		TypeMetaData javaType = amd.getJavaType();
		if (javaType == null) {
			s.append("?");
		} else {
			s.append(javaType.getShortName());
		}
		return s.toString();
	}
	
	/**
	 * Append a comma separated list of the names of the OrmColumn's in cols 
	 * to s. Does nothing if cols is null or empty.
	 */
	protected void appendColumnNames(StringBuffer s, List cols) {
		int n = cols == null ? 0 : cols.size();
		if (n == 0) {
			return;
		}
		s.append(((OrmColumn)cols.get(0)).getName());
		for (int i = 1; i < n; i++) {
			s.append(", ");
			s.append(((OrmColumn)cols.get(i)).getName());
		}
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(AttributeMetaData.class)) {
			case MetadataPackage.ATTRIBUTE_META_DATA__NAME:
			case MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE:
			case MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE:
			case MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL:
			case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public ResourceLocator getResourceLocator() {
		return MetadataEditPlugin.INSTANCE;
	}

}
