/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Widget;

public class AttMappedByBinding extends EmfAbstractBinding implements SelectionListener{
    private CCombo combo;
    private List choices;
    
    /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget) {
        super.bind(adapterFactory, widget, MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY);
        this.combo = (CCombo) widget;
    }

    protected void installListeners() {
        super.installListeners();
        combo.addSelectionListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        combo.removeSelectionListener(this);
    }

    protected void setChoicesFromModel(IItemLabelProvider labelProvider, Collection choices) {
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        choices = new ArrayList();
        combo.removeAll();
        combo.add("<None>");
        choices.add(null);
        AttributeMetaData mappedBy = (AttributeMetaData) value;
        if(mappedBy != null){
            combo.setText(mappedBy.getName());
        }else{
            combo.setText("");
            combo.select(0);
        }
        AttributeMetaData attributeMD = (AttributeMetaData) getTarget();
        IEntityModelManager emm = (IEntityModelManager) attributeMD .adapt(IEntityModelManager.class);
        if(emm != null){
            List atts = emm.getValidMappedByAttribute(attributeMD);
            for (int x = 0; x < atts.size(); x++) {
                AttributeMetaData att = (AttributeMetaData) atts.get(x);
                combo.add(att.getName());
                choices.add(att);
                if(att == mappedBy){
                    combo.select(x+1);
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        int selectionIndex = combo.getSelectionIndex();
        if(selectionIndex >= 0){
            setValuesFromWidget(choices.get(selectionIndex));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
