/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EmfTextBinding extends EmfAbstractBinding implements ModifyListener{
    private Text text;
    private Runnable lastTask;
    /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        super.bind(adapterFactory, widget, featureId);
        this.text = (Text) widget;
    }

    protected void installListeners() {
        super.installListeners();
        if (!text.isDisposed()) {
            text.addModifyListener(this);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (!text.isDisposed()) {
            text.removeModifyListener(this);
        }
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        if (!text.isDisposed()) {
            text.setText(labelProvider.getText(value));
        }
    }

    protected void setChoicesFromModel(IItemLabelProvider provider, Collection choices) {
    }

    public void modifyText(ModifyEvent e) {
        final String text2 = text.getText();
        lastTask = new Runnable() {
            public void run() {
                if(lastTask == this){
                    setValuesFromWidget(text2);
                }
            }
        };
        text.getDisplay().timerExec(400, lastTask);          
    }
}
