/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class MessageEditPart extends AbstractGraphicalEditPart {

    /**
     * 
     */
    public MessageEditPart(Object model) {
        super();
        setModel(model);
    }

    protected IFigure createFigure() {
        Label label = new Label();
        return label;
    }

    protected void createEditPolicies() {
    }
    
    protected void refreshVisuals() {
        Message message = (Message)getModel();
        Label label = (Label)getFigure();
        label.setText(message.getText());
        label.setIcon(message.getIcon());
        Font messageFont = message.getFont();
        if (messageFont != null) {
            label.setFont(messageFont);
        }
        Color foregroundColor = message.getForegroundColor();
        if (foregroundColor != null) {
            label.setForegroundColor(foregroundColor);
        }
        Color backgroundColor = message.getBackgroundColor();
        if (backgroundColor != null) {
            label.setBackgroundColor(backgroundColor);
            label.setOpaque(true);
        }else{
            label.setOpaque(false);
        }
    }

}
