/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class RdbColumnDragCommand extends Command {

    private Column rdbColumn;

    private OrmColumn ormColumn;

    public RdbColumnDragCommand(OrmColumn ormColumn, Column rdbColumn) {
        this.ormColumn = ormColumn;
        this.rdbColumn = rdbColumn;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public void execute() {
        RdbUtils.copyToOrm(ormColumn, rdbColumn);
    }

}
