/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.views.MappingView;
import org.eclipse.jsr220orm.ui.internal.wizards.AddPersistenceWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddPersistenceComposite {

    private static final String ADD_PERSISTENCE= "addPersistence-";
    private FormText formText;
    private Form mainForm;
    private IProject project;
    private MappingView view;

    public AddPersistenceComposite(MappingView view) {
        this.view = view;
    }

    public Composite getComposite(){
        return mainForm;
    }
    
    public void setIProject(IProject project){
        this.project = project;
        formText.setText(getText(project), true, false);
    }
    
    public void createComposite(Composite parent, int style, FormToolkit toolkit){
        mainForm = toolkit.createForm(parent);
        mainForm.setText("Project persistence disabled");
        GridLayout gridLayout = new GridLayout();
        mainForm.getBody().setLayout(gridLayout);
        formText = toolkit.createFormText(mainForm.getBody(), true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        formText.setLayoutData(gridData);
        formText.setImage("addClass", OrmUiPlugin.getImageDescriptor("icons/memoryreset_tsk_002.gif").createImage()); 
        formText.addHyperlinkListener(new HyperlinkAdapter() {
            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.startsWith(ADD_PERSISTENCE)){ 
                    addPersistence(project);
                }
            }
        });
    }

    private void addPersistence(IProject project) {
        IWizard wizard = new AddPersistenceWizard(project);
        WizardDialog dialog = new WizardDialog(Display.getCurrent()
                .getActiveShell(), wizard);
        dialog.create();
        dialog.open();
        view.doUpdate(true);
    }

    private String getText(IProject project) {
        StringBuffer buffer = new StringBuffer("<form>\n");
        String name = project.getName();
        buffer.append("<p><img href=\"addClass\"/><a href=\"");
        buffer.append(ADD_PERSISTENCE);
        buffer.append(name);
        buffer.append("\">Select a Persistence product </a> for project: ");
        buffer.append(name);
        buffer.append(".</p>\n");
        buffer.append("</form>");
        return buffer.toString();
    }
}
