/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.binding.EmfWidgetBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EntEntityTypeBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EntUseDiscriminatorBinding;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class EntityComposite {

    // private Text tFullName;
    private Text tSchemaName;
    private CCombo tAccessType;
    private Text tIdCLass;
    private CCombo tIdGeneratorType;
    private Text tIdGeneratorName;
    private EntEntityTypeBinding entityTypeBinding = new EntEntityTypeBinding();
    private EmfWidgetBinding tSchemaNameBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tAccessTypeBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdCLassBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdGeneratorTypeBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdGeneratorNameBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tInheritanceBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tDiscriminatorValueBinding = new EmfWidgetBinding();
    private EntUseDiscriminatorBinding tUseDiscriminatorBinding = new EntUseDiscriminatorBinding();
    private EntityMetaData entityMetaData;
    private Hyperlink lIdClass = null;
    private CCombo tInheritanceType;
    private Button tUseDiscriminator;
    private Text tDiscriminatorValue;
    private ScrolledForm scrolledForm;

    public Composite createComposite(final Composite parent, FormToolkit toolkit) {
        List factories = new ArrayList();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());

        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(
                factories);
//        ScrolledForm scrolledForm = toolkit.createScrolledForm(section);
        scrolledForm = new ScrolledForm(parent, SWT.V_SCROLL | SWT.VERTICAL);
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setMinWidth(0);
        toolkit.adapt(scrolledForm);
        Composite composite = scrolledForm.getBody();
//        Composite composite = toolkit.createComposite(scrolledForm.getBody());
//        composite.set
        GridLayout thisLayout = new GridLayout();
        composite.setLayout(thisLayout);
        thisLayout.numColumns = 2;
        toolkit.createLabel(composite, "Mapping");
        CCombo tEntityType = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        entityTypeBinding.bind(adapterFactory, tEntityType, MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE);
        toolkit.adapt(tEntityType);
        tEntityType.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        toolkit.createLabel(composite, "Name");
        tSchemaName = toolkit.createText(composite, "", SWT.BORDER);
        tSchemaNameBinding.bind(adapterFactory, tSchemaName,
                MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME);
        tSchemaName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        toolkit.createLabel(composite, "Access Type");
        GridData tAccessTypeLData = new GridData();
        tAccessTypeLData.grabExcessHorizontalSpace = true;
        tAccessTypeLData.widthHint = 75;
        tAccessType = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        tAccessTypeBinding.bind(adapterFactory, tAccessType,
                MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE);
        tAccessType.setLayoutData(tAccessTypeLData);
        tAccessType.setEditable(false);
        toolkit.adapt(tAccessType);
        GridData tIdCLassLData = new GridData();
        tIdCLassLData.grabExcessHorizontalSpace = true;
        tIdCLassLData.horizontalAlignment = GridData.FILL;
        lIdClass = toolkit.createHyperlink(composite, "ID class",
                SWT.NONE);
        lIdClass.addHyperlinkListener(new HyperlinkAdapter() {
            public void linkActivated(HyperlinkEvent e) {
                findIdClass();
            }
        });
        tIdCLass = toolkit.createText(composite, "", SWT.BORDER);
        tIdCLass.setLayoutData(tIdCLassLData);
        tIdCLassBinding.bind(adapterFactory, tIdCLass,
                MetadataPackage.ENTITY_META_DATA__ID_CLASS);
        toolkit.createLabel(composite, "ID generator type");
        GridData tIdGeneratorTypeLData = new GridData();
        tIdGeneratorTypeLData.grabExcessHorizontalSpace = true;
        tIdGeneratorTypeLData.widthHint = 100;
        tIdGeneratorType = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        tIdGeneratorTypeBinding.bind(adapterFactory, tIdGeneratorType,
                MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE);
        tIdGeneratorType.setLayoutData(tIdGeneratorTypeLData);
        toolkit.adapt(tIdGeneratorType);
        toolkit.createLabel(composite, "ID generator name");
        GridData tIdGeneratorNameLData = new GridData();
        tIdGeneratorNameLData.grabExcessHorizontalSpace = true;
        tIdGeneratorNameLData.horizontalAlignment = GridData.FILL;
        tIdGeneratorName = toolkit.createText(composite, "", SWT.BORDER);
        tIdGeneratorNameBinding.bind(adapterFactory, tIdGeneratorName,
                MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME);
        tIdGeneratorName.setLayoutData(tIdGeneratorNameLData);
        toolkit.createLabel(composite, "Inheritance type");
        tInheritanceType = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        GridData tInheritanceTypeData = new GridData();
        tInheritanceTypeData.widthHint = 100;
        tInheritanceType.setLayoutData(tInheritanceTypeData);
        toolkit.adapt(tInheritanceType);
        tInheritanceBinding.bind(adapterFactory, tInheritanceType, MetadataPackage.ENTITY_META_DATA__INHERITANCE);
        toolkit.createLabel(composite, "Use discriminator");
        tUseDiscriminator = toolkit.createButton(composite, "", SWT.CHECK);
        tUseDiscriminatorBinding.bind(adapterFactory, tUseDiscriminator);
        toolkit.createLabel(composite, "Discriminator value");
        tDiscriminatorValue = toolkit.createText(composite, "",SWT.BORDER);
        GridData tDiscriminatorData = new GridData();
        tDiscriminatorData.grabExcessHorizontalSpace = true;
        tDiscriminatorData.horizontalAlignment = GridData.FILL;
        tDiscriminatorValue.setLayoutData(tDiscriminatorData);
        tDiscriminatorValueBinding.bind(adapterFactory, tDiscriminatorValue, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE);
        return scrolledForm;
    }

    private String getTile(EntityMetaData entityMetaData) {
        String schemaName = entityMetaData.getSchemaName();
        return schemaName != null ? schemaName : entityMetaData.getClassName();
    }
 
    public Composite getComposite() {
        return scrolledForm;
    }

    protected void findIdClass() {
        try {
            IProject project = (IProject) entityMetaData.adapt(IProject.class);
            SelectionDialog select = JavaUI.createTypeDialog(
                    scrolledForm.getShell(), null, project,
                    IJavaElementSearchConstants.CONSIDER_CLASSES, false);
            if (select.open() == SelectionDialog.OK) {
                Object[] result = select.getResult();
                if (result.length > 0) {
                    IType type = (IType) result[0];
                    tIdCLass.setText(type.getFullyQualifiedName());
                }
            }
        } catch (JavaModelException e) {
            OrmUiPlugin.logException(e, "Error finding class", scrolledForm.getShell());
        }
    }

    public EntityMetaData getEntityMetaData() {
        return entityMetaData;
    }

    public void setEntityMetaData(EntityMetaData entityMetaData) {
        this.entityMetaData = entityMetaData;
        entityTypeBinding.setEObject(entityMetaData);
        tSchemaNameBinding.setEObject(entityMetaData);
        tAccessTypeBinding.setEObject(entityMetaData);
        tIdCLassBinding.setEObject(entityMetaData);
        tIdGeneratorTypeBinding.setEObject(entityMetaData);
        tIdGeneratorNameBinding.setEObject(entityMetaData);
        tInheritanceBinding.setEObject(entityMetaData);
        tDiscriminatorValueBinding.setEObject(entityMetaData);
        tUseDiscriminatorBinding.setEObject(entityMetaData);
        IEntityModelManager emm = (IEntityModelManager) 
            entityMetaData.adapt(IEntityModelManager.class);
        boolean idGeneratorEnabled = false;
        if (emm != null) {
            idGeneratorEnabled = emm.isIdGeneratorEnabled(entityMetaData);
        }
        tIdGeneratorType.setEnabled(idGeneratorEnabled);
        tIdGeneratorName.setEnabled(idGeneratorEnabled);
    }
}
