/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ReferenceAttributeComposite extends AttributeComposite {

    public Composite createComposite(Composite parent, FormToolkit toolkit, AdapterFactory adapterFactory) {
        Composite composite = super.createComposite(parent, toolkit, adapterFactory);
        addCascade(composite, toolkit, adapterFactory, MetadataPackage.REFERENCE_ATTRIBUTE__CASCADE_TYPE);
        addMappedBy(composite, toolkit, adapterFactory);
        return composite;
    }
}
