/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views.provider;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class OutlineLabelProvider implements ILabelProvider {

	protected AdapterFactoryLabelProvider labelProvider;

	public OutlineLabelProvider(ComposedAdapterFactory adapterFactory) {
		labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
	}

	public void addListener(ILabelProviderListener listener) {
		labelProvider.addListener(listener);
	}

	public void dispose() {
		labelProvider.dispose();

	}

	public boolean isLabelProperty(Object element, String property) {
		return labelProvider.isLabelProperty(element, property);
	}

	public void removeListener(ILabelProviderListener listener) {
		labelProvider.removeListener(listener);
	}

	public Image getImage(Object element) {
		if (element == null || element instanceof IProject) {
			return PlatformUI.getWorkbench().getSharedImages().getImage(
					org.eclipse.ui.ide.IDE.SharedImages.IMG_OBJ_PROJECT);
		} else if (element instanceof OrmProject) {
			return ((OrmProject) element).getProduct().getIcon();
		}
		return labelProvider.getImage(element);

	}

	public String getText(Object element) {
		return labelProvider.getText(element);
	}
}
