/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchEditResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelExtensionRegistry;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.IEditModelFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EditModelRegistry
extends RegistryReader {
    private static final EditModelRegistry INSTANCE = new EditModelRegistry();
    private final Map factoryConfigurations = new HashMap();
    private static boolean initialized = false;
    public static final String EDIT_MODEL_ELEMENT = "editModel";
    public static final String EDIT_MODEL_RESOURCE_EXTENSION = "resourceExtension";
    public static final String EDIT_MODEL_RESOURCE_EXTENSION_NAME = "name";
    public static final String EDIT_MODEL_ID_ATTR = "editModelID";
    public static final String FACTORY_CLASS_ATTR = "factoryClass";
    public static final String PARENT_MODEL_ATTR = "parentModelID";
    public static final String LOAD_UNKNOWN_RESOURCES_ATTR = "loadUnknownResourcesAsReadOnly";

    protected EditModelRegistry() {
        super("org.eclipse.wst.common.emfworkbench.integration", EDIT_MODEL_ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditModelRegistry getInstance() {
        if (EditModelRegistry.isInitialized()) {
            return INSTANCE;
        }
        EditModelRegistry editModelRegistry = INSTANCE;
        synchronized (editModelRegistry) {
            if (!EditModelRegistry.isInitialized()) {
                INSTANCE.readRegistry();
                initialized = true;
            }
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        String editModelID;
        boolean result = false;
        if (element.getName().equals(EDIT_MODEL_ELEMENT) && (editModelID = element.getAttribute(EDIT_MODEL_ID_ATTR)) != null) {
            this.factoryConfigurations.put(editModelID, new EditModelInfo(editModelID, element));
            result = true;
        }
        return result;
    }

    public String getCacheID(String editModelID, Map params) {
        IEditModelFactory factory = this.getEditModelFactoryByKey(editModelID);
        return factory.getCacheID(editModelID, params);
    }

    public EditModel createEditModelForRead(String editModelID, EMFWorkbenchContext context, Map params) {
        return this.getEditModelFactoryByKey(editModelID).createEditModelForRead(editModelID, context, params);
    }

    public EditModel createEditModelForWrite(String editModelID, EMFWorkbenchContext context, Map params) {
        return this.getEditModelFactoryByKey(editModelID).createEditModelForWrite(editModelID, context, params);
    }

    public Collection getEditModelResources(String editModelID) {
        TreeSet resources = new TreeSet();
        EditModelInfo nextEditModelInfo = this.getEditModelInfoById(editModelID);
        String parentModelID = null;
        HashMap visitedEditModels = new HashMap();
        while (nextEditModelInfo != null && (parentModelID = nextEditModelInfo.getParentModelID()) != null) {
            if (visitedEditModels.containsKey(parentModelID)) {
                throw new IllegalStateException(EMFWorkbenchEditResourceHandler.getString(EMFWorkbenchEditResourceHandler.EditModelRegistry_ERROR_0, new Object[]{editModelID}));
            }
            visitedEditModels.put(parentModelID, null);
            resources.addAll(this.getAllEditModelResources(parentModelID));
            nextEditModelInfo = this.getEditModelInfoById(parentModelID);
        }
        resources.addAll(this.getAllEditModelResources(editModelID));
        return resources;
    }

    public Collection getEditModelExtensions(String editModelID) {
        TreeSet extensions = new TreeSet();
        EditModelInfo nextEditModelInfo = this.getEditModelInfoById(editModelID);
        String parentModelID = null;
        HashMap visitedEditModels = new HashMap();
        while (nextEditModelInfo != null && (parentModelID = nextEditModelInfo.getParentModelID()) != null) {
            if (visitedEditModels.containsKey(parentModelID)) {
                throw new IllegalStateException(EMFWorkbenchEditResourceHandler.getString(EMFWorkbenchEditResourceHandler.EditModelRegistry_ERROR_0, new Object[]{editModelID}));
            }
            visitedEditModels.put(parentModelID, null);
            extensions.addAll(this.getAllEditModelExtensions(parentModelID));
            nextEditModelInfo = this.getEditModelInfoById(parentModelID);
        }
        extensions.addAll(this.getAllEditModelExtensions(editModelID));
        return extensions;
    }

    public IEditModelFactory findEditModelFactoryByKey(Object editModelID) {
        IEditModelFactory factory = null;
        EditModelInfo editMdlInfo = (EditModelInfo)this.factoryConfigurations.get(editModelID);
        if (editMdlInfo != null) {
            factory = editMdlInfo.getEditModelFactory();
        }
        return factory;
    }

    public IEditModelFactory findEditModelFactoryByProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (Exception exception) {
            return null;
        }
        if (facetedProject == null) {
            return null;
        }
        Iterator keys = this.factoryConfigurations.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String)) continue;
            try {
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)((String)key));
                if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet)) continue;
                return this.findEditModelFactoryByKey(key);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected Collection getAllEditModelResources(String editModelID) {
        ArrayList resources = new ArrayList();
        resources.addAll(this.getLocalEditModelResources(editModelID));
        resources.addAll(this.getExtendedEditModelResources(editModelID));
        return resources;
    }

    protected Collection getAllEditModelExtensions(String editModelID) {
        ArrayList resources = new ArrayList();
        resources.addAll(this.getLocalEditModelExtensions(editModelID));
        return resources;
    }

    protected Collection getLocalEditModelResources(String editModelID) {
        EditModelInfo editMdlInfo = this.getEditModelInfoById(editModelID);
        return editMdlInfo != null ? editMdlInfo.getEditModelResources() : Collections.EMPTY_LIST;
    }

    protected Collection getLocalEditModelExtensions(String editModelID) {
        EditModelInfo editMdlInfo = this.getEditModelInfoById(editModelID);
        return editMdlInfo != null ? editMdlInfo.getEditModelExtensions() : Collections.EMPTY_LIST;
    }

    protected Collection getExtendedEditModelResources(String editModelID) {
        return EditModelExtensionRegistry.getInstance().getEditModelResources(editModelID);
    }

    protected IEditModelFactory getEditModelFactoryByKey(Object editModelID) {
        IEditModelFactory factory = null;
        EditModelInfo editMdlInfo = this.getEditModelInfoById(editModelID);
        if (editMdlInfo == null) {
            throw new IllegalArgumentException(EMFWorkbenchEditResourceHandler.getString(EMFWorkbenchEditResourceHandler.EditModelRegistry_ERROR_2, new Object[]{editModelID}));
        }
        factory = editMdlInfo.getEditModelFactory();
        return factory;
    }

    protected EditModelInfo getEditModelInfoById(Object editModelID) {
        this.waitForInitializationIfNecessary();
        return (EditModelInfo)this.factoryConfigurations.get(editModelID);
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void waitForInitializationIfNecessary() {
        if (EditModelRegistry.isInitialized()) return;
        EditModelRegistry editModelRegistry = INSTANCE;
        // MONITORENTER : editModelRegistry
        // MONITOREXIT : editModelRegistry
    }

    protected static boolean isInitialized() {
        return initialized;
    }

    public String[] getRegisteredEditModelIDs() {
        return this.factoryConfigurations.keySet().toArray(new String[this.factoryConfigurations.keySet().size()]);
    }

    public class EditModelInfo {
        private String editModelID = null;
        private IConfigurationElement configurationElement = null;
        private IEditModelFactory factory = null;
        private List editModelResources = null;
        private List editModelExtensions = null;
        private String parentModelID = null;
        private String tostringCache = null;

        public EditModelInfo(String editModelID, IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
            this.editModelID = editModelID;
            this.parentModelID = this.configurationElement.getAttribute(EditModelRegistry.PARENT_MODEL_ATTR);
        }

        public List getEditModelResources() {
            this.initializeResources();
            return this.editModelResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IEditModelFactory getEditModelFactory() {
            if (this.factory == null) {
                EditModelInfo editModelInfo = this;
                synchronized (editModelInfo) {
                    if (this.factory == null) {
                        if (this.configurationElement != null) {
                            try {
                                this.factory = (IEditModelFactory)this.configurationElement.createExecutableExtension(EditModelRegistry.FACTORY_CLASS_ATTR);
                                Boolean value = Boolean.valueOf(this.configurationElement.getAttribute(EditModelRegistry.LOAD_UNKNOWN_RESOURCES_ATTR));
                                this.factory.setLoadKnownResourcesAsReadOnly(value);
                                this.discardConfigurationElementIfNecessary();
                            }
                            catch (CoreException e) {
                                Logger.getLogger((String)"org.eclipse.wst.common.emfworkbench.integration").logError((Throwable)e);
                            }
                        } else {
                            Logger.getLogger().logError(EMFWorkbenchEditResourceHandler.EditModelRegistry_ERROR_1);
                        }
                    }
                }
            }
            return this.factory;
        }

        private synchronized void initializeResources() {
            if (this.editModelResources == null) {
                if (this.configurationElement != null) {
                    this.editModelResources = new ArrayList();
                    IConfigurationElement[] resources = this.configurationElement.getChildren("editModelResource");
                    IConfigurationElement[] resExtensions = this.configurationElement.getChildren(EditModelRegistry.EDIT_MODEL_RESOURCE_EXTENSION);
                    this.discardConfigurationElementIfNecessary();
                    int j = 0;
                    while (j < resources.length) {
                        this.editModelResources.add(new EditModelResource(resources[j]));
                        ++j;
                    }
                    if (resExtensions == null || resExtensions.length == 0) {
                        this.editModelExtensions = Collections.EMPTY_LIST;
                    } else {
                        this.editModelExtensions = new ArrayList();
                        int i = 0;
                        while (i < resExtensions.length) {
                            String extension = resExtensions[i].getAttribute(EditModelRegistry.EDIT_MODEL_RESOURCE_EXTENSION_NAME);
                            this.editModelExtensions.add(extension);
                            ++i;
                        }
                    }
                } else {
                    this.editModelResources = Collections.EMPTY_LIST;
                    this.editModelExtensions = Collections.EMPTY_LIST;
                }
            }
        }

        private void discardConfigurationElementIfNecessary() {
            if (this.editModelResources != null && this.factory != null) {
                this.configurationElement = null;
            }
        }

        public String toString() {
            if (this.tostringCache == null) {
                this.tostringCache = "EditModelID: {" + this.editModelID + "}, Parent Model ID {" + this.parentModelID + "}, Configuration Element: [" + this.configurationElement + "]";
            }
            return this.tostringCache;
        }

        public String getParentModelID() {
            return this.parentModelID;
        }

        public List getEditModelExtensions() {
            this.initializeResources();
            return this.editModelExtensions;
        }
    }
}

