/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.mappings.details.MapAsComposite;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentTypeMapAsComposite<T extends PersistentType>
extends MapAsComposite<T> {
    public PersistentTypeMapAsComposite(AbstractPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("mappingProperty");
        propertyNames.add("nameProperty");
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String labelText() {
                String mappingKey = ((PersistentType)PersistentTypeMapAsComposite.this.subject()).getMappingKey();
                if (mappingKey != null) {
                    return JptUiMessages.MapAsComposite_mappedTypeText;
                }
                return JptUiMessages.MapAsComposite_unmappedTypeText;
            }

            @Override
            public String mappingType() {
                String mappingKey = ((PersistentType)PersistentTypeMapAsComposite.this.subject()).getMappingKey();
                if (mappingKey == null) {
                    return JptUiMessages.MapAsComposite_changeMappingType;
                }
                return SWTUtil.buildDisplayString(JptUiMessages.class, MapAsComposite.class, (Object)mappingKey);
            }

            @Override
            public void morphMapping(MappingUiProvider<?> provider) {
                ((PersistentType)PersistentTypeMapAsComposite.this.subject()).setMappingKey(provider.getMappingKey());
            }

            @Override
            public String name() {
                return ((PersistentType)PersistentTypeMapAsComposite.this.subject()).getName();
            }

            @Override
            public Iterator<? extends MappingUiProvider<?>> providers() {
                return PersistentTypeMapAsComposite.this.typeMappingUiProviders();
            }
        };
    }

    protected JpaPlatformUi jpaPlatformUi() {
        String platformId = ((PersistentType)this.subject()).getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().jpaPlatform(platformId);
    }

    @Override
    protected String mappingKey() {
        return ((PersistentType)this.subject()).getMappingKey();
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "mappingProperty" || propertyName == "nameProperty") {
            this.updateDescription();
        }
    }

    protected abstract Iterator<TypeMappingUiProvider<? extends TypeMapping>> typeMappingUiProviders();
}

