/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;

public class WorkbenchByteArrayOutputStream
extends URIConverterImpl.PlatformResourceOutputStream {
    private boolean fConvertEOL = false;
    protected ResourceSetWorkbenchSynchronizer synchronizer;

    public WorkbenchByteArrayOutputStream(IFile aFile) {
        this(aFile, null);
    }

    public WorkbenchByteArrayOutputStream(IFile aFile, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super(aFile, false, true, null);
        this.synchronizer = aSynchronizer;
    }

    public void close() throws IOException {
        if (this.synchronizer != null) {
            this.synchronizer.preSave(this.file);
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.synchronizer != null) {
            this.synchronizer.preSave(this.file);
        }
        super.flush();
    }

    private int convertEOL(byte[] data) {
        String EOL = System.getProperties().getProperty("line.separator");
        byte[] EOLBytes = EOL.getBytes();
        int out = 0;
        int in = 0;
        while (in < data.length) {
            if (data[in] != 13) {
                if (data[in] == 10) {
                    if (in - out + 1 < EOLBytes.length) {
                        throw new UnsupportedOperationException("WorkbenchByteArrayOutputStream: Expanding EOL chars not implemented");
                    }
                    int i = 0;
                    while (i < EOLBytes.length) {
                        data[out++] = EOLBytes[i];
                        ++i;
                    }
                } else {
                    data[out++] = data[in];
                }
            }
            ++in;
        }
        return out;
    }

    public boolean isConvertEOLChars() {
        return this.fConvertEOL;
    }

    public void setConvertEOLChars(boolean set) {
        this.fConvertEOL = set;
    }

    public synchronized byte[] toByteArray() {
        byte[] contents = super.toByteArray();
        if (this.isConvertEOLChars()) {
            this.convertEOL(contents);
        }
        return contents;
    }
}

