/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jst.j2ee.internal.dialogs.J2EEDeployUIConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class J2EEDeployStatusDialog
extends ProgressMonitorDialog
implements J2EEDeployUIConstants {
    private static final int LIST_ITEM_COUNT = 7;
    private int severity = 0;
    public Color DESC_COLOR = new Color(null, 255, 255, 255);
    private Button detailsButton;
    private Text text;
    private boolean textCreated = false;
    private List statusList;

    public J2EEDeployStatusDialog(Shell parent, List status) {
        super(parent);
        this.setShellStyle(67632);
        this.statusList = status;
    }

    protected void finishedRun() {
        this.decrementNestingDepth();
        this.clearCursors();
        this.cancel.setEnabled(true);
        this.detailsButton.setEnabled(true);
        this.computeSeverity();
        this.setDeploymentStatus();
    }

    private void setDeploymentStatus() {
        this.setMessageOrDefault();
        this.imageLabel.setImage(this.getImage());
    }

    protected void setMessageOrDefault() {
        switch (this.getSeverity()) {
            case 4: {
                this.message = DEPLOY_ERRORS_REPORT;
                break;
            }
            case 2: {
                this.message = DEPLOY_WARNINGS_REPORT;
                break;
            }
            default: {
                this.message = DEPLOY_SUCCESS_REPORT;
            }
        }
        this.setMessage(this.message);
    }

    protected void createCancelButton(Composite parent) {
        super.createCancelButton(parent);
        this.cancel.setText(IDialogConstants.OK_LABEL);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createCancelButton(parent);
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        this.detailsButton.setEnabled(false);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            this.logStatus();
            super.buttonPressed(id);
        }
    }

    protected Image getImage() {
        switch (this.getSeverity()) {
            case 4: {
                return this.getErrorImage();
            }
            case 2: {
                return this.getWarningImage();
            }
        }
        return this.getInfoImage();
    }

    protected Text createDropDownText(Composite parent) {
        this.text = new Text(parent, 2818);
        this.populateText(this.text);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.text.getLineHeight() * 7;
        this.text.setLayoutData((Object)data);
        this.textCreated = true;
        return this.text;
    }

    private void logStatus() {
        Iterator aenum = this.statusList.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append(this.message);
        while (aenum.hasNext()) {
            IStatus childStatus = (IStatus)aenum.next();
            this.populateText(sb, childStatus, 0);
        }
        Logger.getLogger().logInfo(sb.toString());
    }

    private void populateText(Text someText) {
        Iterator aenum = this.statusList.iterator();
        StringBuffer sb = new StringBuffer();
        while (aenum.hasNext()) {
            IStatus childStatus = (IStatus)aenum.next();
            this.populateText(sb, childStatus, 0);
        }
        someText.setText(sb.toString());
    }

    private void populateText(StringBuffer sb, IStatus status, int nesting) {
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        sb.append(this.getMessageForDisplay(status));
        sb.append('\n');
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.populateText(sb, children[i2], nesting + 1);
            ++i2;
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.textCreated) {
            this.text.dispose();
            this.textCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.text = this.createDropDownText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.text.setEditable(false);
            this.text.setBackground(this.DESC_COLOR);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    public String getMessageForDisplay(IStatus status) {
        String messageString = status.getMessage();
        return messageString;
    }

    protected String getSeverityText(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return ERROR_TEXT;
            }
            case 2: {
                return WARNING_TEXT;
            }
            case 1: {
                return INFO_TEXT;
            }
            case 0: {
                return OK_TEXT;
            }
        }
        return "";
    }

    private void setSeverity(int sev) {
        if (this.severity == 4) {
            return;
        }
        if (sev == 4) {
            this.severity = 4;
        } else if (sev == 2) {
            this.severity = 2;
        }
    }

    private int getSeverity() {
        return this.severity;
    }

    private int computeSeverity() {
        for (IStatus childStatus : this.statusList) {
            this.setSeverity(childStatus.getSeverity());
            if (this.getSeverity() == 4) {
                return this.getSeverity();
            }
            this.computeSeverity(childStatus);
            if (this.getSeverity() != 4) continue;
            this.getSeverity();
        }
        return this.getSeverity();
    }

    private void computeSeverity(IStatus status) {
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.computeSeverity(children[i]);
            if (this.getSeverity() == 4) {
                return;
            }
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DEPLOY_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.setMessage(DEPLOYMENT_IN_PROGRESS);
        return control;
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }
}

