/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.validation;

import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.validation.MarkupValidator;

public class JSPMarkupValidator
extends MarkupValidator {
    private boolean hasXMLAttributes(IStructuredDocumentRegion structuredDocumentRegion) {
        ITextRegion region;
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        return regions.size() > 1 && regions.get(0).getType() == "XML_TAG_OPEN" && ((region = regions.get(1)).getType() == "XML_TAG_NAME" || region.getType() == "JSP_DIRECTIVE_NAME") && structuredDocumentRegion.getText(region).indexOf(":") != -1;
    }

    protected void checkForAttributeValue(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        if (this.hasXMLAttributes(structuredDocumentRegion)) {
            super.checkForAttributeValue(structuredDocumentRegion, reporter);
        }
        int attrState = 0;
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int i = 0;
        while (i < textRegions.size() && errorCount < 25) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || this.isTagCloseTextRegion(textRegion)) {
                ITextRegion nameRegion;
                if (attrState == 2 && i >= 2 && !((nameRegion = textRegions.get(i - 2)) instanceof ITextRegionContainer)) {
                    Object[] args = new Object[]{structuredDocumentRegion.getText(nameRegion)};
                    String messageText = NLS.bind((String)XMLUIMessages.Attribute__is_missing_a_value, (Object[])args);
                    int start = structuredDocumentRegion.getStartOffset(nameRegion);
                    int end = structuredDocumentRegion.getEndOffset();
                    int textLength = structuredDocumentRegion.getText(nameRegion).trim().length();
                    ITextRegion equalsRegion = textRegions.get(i - 2 + 1);
                    int insertOffset = structuredDocumentRegion.getTextEndOffset(equalsRegion) - end;
                    Object[] additionalFixInfo = new Object[]{structuredDocumentRegion.getText(nameRegion), new Integer(insertOffset)};
                    this.addAttributeError(messageText, additionalFixInfo, start, textLength, 4, structuredDocumentRegion, reporter);
                    ++errorCount;
                }
                attrState = 1;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                attrState = 2;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrState = 0;
            }
            ++i;
        }
    }

    protected void checkQuotesForAttributeValues(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        String attrValueText = "";
        int errorCount = 0;
        if (this.hasXMLAttributes(structuredDocumentRegion)) {
            super.checkQuotesForAttributeValues(structuredDocumentRegion, reporter);
        }
        int i = 0;
        while (i < regions.size() && errorCount < 25) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValueText = structuredDocumentRegion.getText(r);
                StringTokenizer st = new StringTokenizer(attrValueText, "\"'", true);
                int size = st.countTokens();
                String one = "";
                String two = "";
                if (size > 0) {
                    one = st.nextToken();
                }
                if (size > 1) {
                    two = st.nextToken();
                }
                if (size <= 2) {
                    String message;
                    if (size == 1) {
                        if (one.equals("\"") || one.equals("'")) {
                            message = XMLUIMessages.ReconcileStepForMarkup_0;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter);
                            ++errorCount;
                        }
                    } else if (size == 2 && (one.equals("'") && !two.equals("'") || one.equals("\"") && !two.equals("\""))) {
                        message = XMLUIMessages.ReconcileStepForMarkup_0;
                        this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter);
                        ++errorCount;
                    }
                }
            }
            ++i;
        }
    }

    private boolean isTagCloseTextRegion(ITextRegion textRegion) {
        return textRegion.getType() == "XML_TAG_CLOSE" || textRegion.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    protected int getMissingEndTagSeverity() {
        int severity = HTMLCorePlugin.getDefault().getPluginPreferences().getInt("elemMissingEnd");
        return severity < 0 ? 4 : severity;
    }
}

