/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.utilities.Namespace;
import org.eclipse.wst.common.internal.emf.utilities.NamespaceAdapter;

public class NamespaceTranslator
extends Translator {
    protected String prefix;

    public NamespaceTranslator(String domName) {
        super(domName, NamespaceAdapter.NOTIFICATION_FEATURE, 1);
        this.initPrefix();
    }

    private void initPrefix() {
        String dName = this.getDOMName(null);
        this.prefix = dName.substring("xmlns:".length());
    }

    public void setMOFValue(EObject emfObject, Object value) {
        NamespaceAdapter.addNamespace(this.prefix, (String)value, emfObject);
    }

    public boolean isSetMOFValue(EObject emfObject) {
        return this.getMOFValue(emfObject) != null;
    }

    public Object getMOFValue(EObject mofObject) {
        return NamespaceAdapter.getNamespaceURIAtThisLevel(this.prefix, mofObject);
    }

    public void unSetMOFValue(EObject emfObject) {
        NamespaceAdapter.removeNamespace(this.prefix, emfObject);
    }

    public boolean featureExists(EObject emfObject) {
        return true;
    }

    public boolean isDataType() {
        return true;
    }

    public boolean isMapFor(Object aFeature, Object oldValue, Object newValue) {
        Namespace namespace;
        if (aFeature == this.feature && (namespace = (Namespace)(oldValue == null ? newValue : oldValue)) != null) {
            return this.prefix.equals(namespace.getPrefix());
        }
        return false;
    }
}

