/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench;

import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedXMIFactoryImpl;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class WorkbenchResourceHelper
extends WorkbenchResourceHelperBase {
    protected static Class REFERENCED_RES_CLASS;
    private static boolean fileAdapterFactoryInitialized;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.internal.emf.resource.ReferencedResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REFERENCED_RES_CLASS = clazz;
        fileAdapterFactoryInitialized = false;
    }

    public static synchronized void initializeFileAdapterFactory() {
        if (!fileAdapterFactoryInitialized) {
            ReferencedXMIFactoryImpl.addGlobalAdapterFactory((AdapterFactory)new FileAdapterFactory());
            fileAdapterFactoryInitialized = true;
        }
    }

    private static FileAdapter getFileAdapter(ReferencedResource res) {
        FileAdapter adapter = (FileAdapter)EcoreUtil.getExistingAdapter((Notifier)res, (Object)FileAdapter.ADAPTER_KEY);
        return adapter == null ? WorkbenchResourceHelper.createFileAdapter(res) : adapter;
    }

    private static FileAdapter createFileAdapter(ReferencedResource res) {
        FileAdapter adapter = new FileAdapter();
        adapter.setTarget((Notifier)res);
        res.eAdapters().add((Object)adapter);
        return adapter;
    }

    public static IFile getFile(ReferencedResource res) {
        FileAdapter adapter = WorkbenchResourceHelper.getFileAdapter(res);
        return adapter == null ? null : adapter.getFile();
    }

    public static long getSynchronizationStamp(ReferencedResource res) {
        FileAdapter adapter = WorkbenchResourceHelper.getFileAdapter(res);
        return adapter == null ? 0L : adapter.getSynchronizationStamp();
    }

    public static void setSynhronizationStamp(ReferencedResource res, long stamp) {
        FileAdapter adapter = WorkbenchResourceHelper.getFileAdapter(res);
        if (adapter != null) {
            adapter.setSynchronizationStamp(stamp);
        }
    }

    public static boolean isConsistent(ReferencedResource res) {
        FileAdapter adapter = WorkbenchResourceHelper.getFileAdapter(res);
        return adapter != null && adapter.isConsistent();
    }

    public static void cacheSynchronizationStamp(ReferencedResource refResource) {
        FileAdapter adapter;
        if (refResource != null && (adapter = WorkbenchResourceHelper.getFileAdapter(refResource)) != null && adapter.getSynchronizationStamp() <= 0L) {
            adapter.setSynchronizationStamp(WorkbenchResourceHelper.computeModificationStamp(refResource));
        }
    }

    public static boolean isReferencedResource(Resource aResource) {
        return REFERENCED_RES_CLASS.isInstance(aResource);
    }

    public static long computeModificationStamp(ReferencedResource resource) {
        FileAdapter adapter = WorkbenchResourceHelper.getFileAdapter(resource);
        return adapter == null ? 0L : WorkbenchResourceHelper.computeModificationStamp(adapter.getFile());
    }

    public static long computeModificationStamp(IFile file) {
        if (file == null) {
            return 0L;
        }
        if (!file.isAccessible()) {
            return -1L;
        }
        long currentStamp = file.getModificationStamp();
        IPath path = file.getLocation();
        if (path != null) {
            return path.toFile().lastModified();
        }
        return currentStamp;
    }

    public static IFile getFile(Resource aResource) {
        if (aResource != null) {
            if (WorkbenchResourceHelper.isReferencedResource(aResource)) {
                return WorkbenchResourceHelper.getFile((ReferencedResource)aResource);
            }
            return WorkbenchResourceHelper.internalGetFile(aResource);
        }
        return null;
    }

    public static IFile getFile(EObject obj) {
        if (obj == null) {
            return null;
        }
        Resource mofResource = obj.eResource();
        if (mofResource == null) {
            return null;
        }
        return WorkbenchResourceHelper.getFile(mofResource);
    }

    public static Resource getOrCreateResource(URI uri, ResourceSet set) throws WrappedException {
        try {
            return set.getResource(uri, true);
        }
        catch (WrappedException e) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(e)) {
                return set.getResource(uri, false);
            }
            throw e;
        }
    }

    protected static boolean isSameProject(Resource resourceA, Resource resourceB) {
        IProject pA = WorkbenchResourceHelper.getProject(resourceA);
        IProject pB = WorkbenchResourceHelper.getProject(resourceB);
        if (pA != null && pB != null) {
            return pA.equals((Object)pB);
        }
        return true;
    }

    public static IProject getProject(Resource res) {
        IFile file;
        IProject proj = WorkbenchResourceHelper.getProject((ResourceSet)res.getResourceSet());
        if (proj == null && (file = WorkbenchResourceHelper.getFile(res)) != null) {
            proj = file.getProject();
        }
        return proj;
    }

    protected static IFile internalGetFile(Resource aResource) {
        if (aResource != null) {
            return WorkbenchResourceHelper.getFile(aResource.getResourceSet(), aResource.getURI());
        }
        return null;
    }

    protected static IFile getFile(ResourceSet set, URI uri) {
        URIConverter converter;
        URI convertedUri;
        IFile file = WorkbenchResourceHelper.getPlatformFile(uri);
        if (file == null && set != null && !uri.equals((Object)(convertedUri = (converter = set.getURIConverter()).normalize(uri)))) {
            return WorkbenchResourceHelper.getPlatformFile(convertedUri);
        }
        return file;
    }

    public static IFile getPlatformFile(URI uri) {
        if (WorkbenchResourceHelper.isPlatformResourceURI((URI)uri)) {
            String fileString = URI.decode((String)uri.path());
            fileString = fileString.substring("resource".length() + 1);
            return WorkbenchResourceHelper.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return null;
    }

    public static IFile getFile(IProject project, URI uri) {
        ResourceSet set = WorkbenchResourceHelper.getResourceSet((IProject)project);
        return WorkbenchResourceHelper.getFile(set, uri);
    }

    public static boolean saveResourceToFile(Resource aResource, IFile aFile) throws Exception {
        return WorkbenchResourceHelper.saveResourceToFile(aResource, aFile, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveResourceToFile(Resource aResource, IFile aFile, Map saveOptions) throws Exception {
        URIConverter conv;
        ResourceSet set;
        if (aResource != null && aFile != null && !aFile.exists() && (set = aResource.getResourceSet()) != null && (conv = set.getURIConverter()) != null && conv instanceof WorkbenchURIConverter) {
            OutputStream os;
            int fileCount;
            WorkbenchURIConverter wbConv = (WorkbenchURIConverter)conv;
            String uri = aResource.getURI().toString();
            Path resPath = new Path(uri);
            IPath filePath = aFile.getProjectRelativePath();
            int resCount = resPath.segmentCount();
            if (resCount <= (fileCount = filePath.segmentCount()) && resPath.equals((Object)(filePath = filePath.removeFirstSegments(fileCount - resCount))) && (os = wbConv.createOutputStream(URI.createPlatformResourceURI((String)aFile.toString()))) != null) {
                try {
                    aResource.save(os, saveOptions);
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    os.close();
                    throw throwable;
                }
                {
                    Object var12_14 = null;
                }
                os.close();
                return true;
            }
        }
        return false;
    }

    protected static void deleteFile(IFile aFile) throws CoreException {
        if (aFile != null && aFile.exists()) {
            aFile.delete(true, null);
        }
    }

    public static void deleteResource(Resource aResource) throws CoreException {
        if (aResource != null) {
            WorkbenchResourceHelper.deleteFile(WorkbenchResourceHelper.getFile(aResource));
        }
    }

    private static class FileAdapter
    extends AdapterImpl {
        public static final Object ADAPTER_KEY;
        private static final long delay = 30L;
        private IFile file;
        private long synchronizationStamp;
        protected ResourceSet previousResourceSet;
        private ILock saveLock;
        public static final int FILE_NOT_LOADED = 0;
        public static final int FILE_INACCESSIBLE = -1;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper$FileAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ADAPTER_KEY = clazz.getName();
        }

        private FileAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return ADAPTER_KEY.equals(type);
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(null)) {
                case 4: {
                    if (this.getResource().isLoaded()) {
                        this.handleLoaded();
                        break;
                    }
                    this.handleUnloaded();
                    break;
                }
                case 602: {
                    this.handleAboutToSave();
                    break;
                }
                case 601: {
                    this.handleSaved();
                    break;
                }
                case 603: {
                    this.handleSaveFailed();
                    break;
                }
                case 1: {
                    this.handleURIChanged();
                }
            }
        }

        private void handleSaveFailed() {
            this.releaseSaveLock();
        }

        private void handleAboutToSave() {
            this.aquireSaveLock();
        }

        private void aquireSaveLock() {
            this.getSaveLock().acquire();
        }

        private boolean aquireSaveLock(long delay) throws InterruptedException {
            return this.getSaveLock().acquire(delay);
        }

        private void releaseSaveLock() {
            this.getSaveLock().release();
        }

        private ILock getSaveLock() {
            if (this.saveLock == null) {
                this.saveLock = Platform.getJobManager().newLock();
            }
            return this.saveLock;
        }

        private void handleURIChanged() {
            this.file = null;
            this.synchronizationStamp = 0L;
        }

        public IFile getFile() {
            if (!(this.file == null || this.file.isAccessible() && this.previousResourceSet == this.getResourceSet())) {
                this.file = null;
                this.synchronizationStamp = 0L;
            }
            if (this.file == null) {
                this.file = WorkbenchResourceHelper.isPlatformResourceURI((URI)this.getURI()) ? WorkbenchResourceHelper.getPlatformFile(this.getURI()) : WorkbenchResourceHelper.internalGetFile((Resource)this.getResource());
                if (this.file != null && !this.file.isAccessible()) {
                    this.synchronizationStamp = -1L;
                }
                this.previousResourceSet = this.getResourceSet();
            }
            return this.file;
        }

        public long getSynchronizationStamp() {
            return this.synchronizationStamp;
        }

        public void setFile(IFile file) {
            this.file = file;
        }

        public void setSynchronizationStamp(long l) {
            this.synchronizationStamp = l;
        }

        /*
         * Exception decompiling
         */
        public boolean isConsistent() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 136->139)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void cacheSynchronizationStamp() {
            this.setSynchronizationStamp(WorkbenchResourceHelper.computeModificationStamp(this.getFile()));
        }

        public ReferencedResource getResource() {
            return (ReferencedResource)this.target;
        }

        public URI getURI() {
            return this.target == null ? null : this.getResource().getURI();
        }

        public ResourceSet getResourceSet() {
            return this.target == null ? null : this.getResource().getResourceSet();
        }

        public void handleUnloaded() {
            this.file = null;
            this.synchronizationStamp = 0L;
        }

        public void handleLoaded() {
            this.cacheSynchronizationStamp();
        }

        public void handleSaved() {
            this.cacheSynchronizationStamp();
            this.releaseSaveLock();
        }
    }

    private static class FileAdapterFactory
    extends AdapterFactoryImpl {
        private FileAdapterFactory() {
        }

        public Adapter adaptNew(Notifier target, Object type) {
            FileAdapter adapter = new FileAdapter();
            adapter.setTarget(target);
            return adapter;
        }
    }
}

