/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

class CalleeAnalyzerVisitor
extends ASTVisitor {
    private CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private IFunction fMethod;
    private JavaScriptUnit fCompilationUnit;
    private IProgressMonitor fProgressMonitor;
    private int fMethodEndPosition;
    private int fMethodStartPosition;

    CalleeAnalyzerVisitor(IFunction method, JavaScriptUnit compilationUnit, IProgressMonitor progressMonitor) {
        this.fMethod = method;
        this.fCompilationUnit = compilationUnit;
        this.fProgressMonitor = progressMonitor;
        try {
            ISourceRange sourceRange = method.getSourceRange();
            this.fMethodStartPosition = sourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + sourceRange.getLength();
        }
        catch (JavaScriptModelException jme) {
            JavaScriptPlugin.log(jme);
        }
    }

    public Map getCallees() {
        return this.fSearchResults.getCallers();
    }

    public boolean visit(ClassInstanceCreation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(FunctionDeclaration node) {
        this.progressMonitorWorked(1);
        return this.isFurtherTraversalNecessary((ASTNode)node);
    }

    public boolean visit(FunctionInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.isNodeEnclosingMethod((ASTNode)node);
    }

    protected void addMethodCall(IFunctionBinding calledMethodBinding, ASTNode node) {
        try {
            if (calledMethodBinding != null) {
                this.fProgressMonitor.worked(1);
                ITypeBinding calledTypeBinding = calledMethodBinding.getDeclaringClass();
                IType calledType = null;
                calledType = !calledTypeBinding.isAnonymous() ? (IType)calledTypeBinding.getJavaElement() : (!"java.lang.Object".equals(calledTypeBinding.getSuperclass().getQualifiedName()) ? (IType)calledTypeBinding.getSuperclass().getJavaElement() : (IType)calledTypeBinding.getInterfaces()[0].getJavaElement());
                IFunction calledMethod = CalleeAnalyzerVisitor.findIncludingSupertypes(calledMethodBinding, calledType, this.fProgressMonitor);
                IType referencedMember = null;
                if (calledMethod == null) {
                    if (calledMethodBinding.isConstructor() && calledMethodBinding.getParameterTypes().length == 0) {
                        referencedMember = calledType;
                    }
                } else {
                    if (calledType.isInterface()) {
                        calledMethod = this.findImplementingMethods(calledMethod);
                    }
                    if (!this.isIgnoredBySearchScope(calledMethod)) {
                        referencedMember = calledMethod;
                    }
                }
                int position = node.getStartPosition();
                int number = this.fCompilationUnit.getLineNumber(position);
                this.fSearchResults.addMember((IMember)this.fMethod, (IMember)referencedMember, position, position + node.getLength(), number < 1 ? 1 : number);
            }
        }
        catch (JavaScriptModelException jme) {
            JavaScriptPlugin.log(jme);
        }
    }

    private static IFunction findIncludingSupertypes(IFunctionBinding method, IType type, IProgressMonitor pm) throws JavaScriptModelException {
        IFunction inThisType = Bindings.findMethod(method, type);
        if (inThisType != null) {
            return inThisType;
        }
        IType[] superTypes = JavaModelUtil.getAllSuperTypes(type, pm);
        int i = 0;
        while (i < superTypes.length) {
            IFunction m = Bindings.findMethod(method, superTypes[i]);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return null;
    }

    private boolean isIgnoredBySearchScope(IFunction enclosingElement) {
        if (enclosingElement != null) {
            return !this.getSearchScope().encloses((IJavaScriptElement)enclosingElement);
        }
        return false;
    }

    private IJavaScriptSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    private boolean isNodeWithinMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        if (nodeStartPosition < this.fMethodStartPosition) {
            return false;
        }
        return nodeEndPosition <= this.fMethodEndPosition;
    }

    private boolean isNodeEnclosingMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        return nodeStartPosition < this.fMethodStartPosition && nodeEndPosition > this.fMethodEndPosition;
    }

    private boolean isFurtherTraversalNecessary(ASTNode node) {
        return this.isNodeWithinMethod(node) || this.isNodeEnclosingMethod(node);
    }

    private IFunction findImplementingMethods(IFunction calledMethod) {
        Collection implementingMethods = CallHierarchy.getDefault().getImplementingMethods(calledMethod);
        if (implementingMethods.size() == 0 || implementingMethods.size() > 1) {
            return calledMethod;
        }
        return (IFunction)implementingMethods.iterator().next();
    }

    private void progressMonitorWorked(int work) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(work);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

