/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.CleanUpAction;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SortMembersMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class MultiSortMembersAction
extends CleanUpAction {
    public MultiSortMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_members_action");
    }

    public MultiSortMembersAction(JavaEditor editor) {
        super(editor);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_members_action");
    }

    protected ICleanUp[] createCleanUps(IJavaScriptUnit[] units) {
        try {
            if (!this.hasMembersToSort(units)) {
                return null;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
        SortMembersMessageDialog dialog = new SortMembersMessageDialog(this.getShell());
        if (dialog.open() != 0) {
            return null;
        }
        Hashtable<String, String> settings = new Hashtable<String, String>();
        settings.put("cleanup.sort_members", "true");
        settings.put("cleanup.sort_members_all", !dialog.isNotSortingFieldsEnabled() ? "true" : "false");
        return new ICleanUp[]{new SortMembersCleanUp(settings)};
    }

    protected String getActionName() {
        return ActionMessages.SortMembersAction_dialog_title;
    }

    private boolean hasMembersToSort(IJavaScriptUnit[] units) throws JavaScriptModelException {
        int i = 0;
        while (i < units.length) {
            if (this.hasMembersToSort(units[i].getChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasMembersToSort(IJavaScriptElement[] members) throws JavaScriptModelException {
        if (members.length > 1) {
            return true;
        }
        if (members.length == 0) {
            return false;
        }
        IJavaScriptElement elem = members[0];
        if (!(elem instanceof IParent)) {
            return false;
        }
        return this.hasMembersToSort(((IParent)elem).getChildren());
    }
}

