/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Vector;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class VThreadManager {
    private static VThreadManager _manager = null;
    private static final int MAX_NUM_OF_RESTART = 5;
    private Thread _validationThread = null;
    volatile int restart = 0;
    volatile Jobs _jobs = new Jobs();

    private VThreadManager() {
        Runnable validationRunnable = new Runnable(){

            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            if (VThreadManager.this.restart > 5) {
                                String message = "restart = " + VThreadManager.this.restart;
                                ValidationPlugin.getPlugin().logMessage(4, message);
                                break block2;
                            }
                            Runnable job = VThreadManager.this.getJobs().dequeue();
                            if (job == null) continue;
                            VThreadManager.this.getJobs().setActive(true);
                            job.run();
                            VThreadManager.this.getJobs().setActive(false);
                        }
                    }
                    catch (Exception e) {
                        ++VThreadManager.this.restart;
                        VThreadManager.this.getJobs().setActive(false);
                        ValidationPlugin.getPlugin().handleException(e);
                        continue;
                    }
                    break;
                }
            }
        };
        this._validationThread = new Thread(validationRunnable, "ValidationThread");
        this._validationThread.start();
    }

    public static VThreadManager getManager() {
        if (_manager == null) {
            _manager = new VThreadManager();
        }
        return _manager;
    }

    Jobs getJobs() {
        return this._jobs;
    }

    public void queue(Runnable runnable) {
        this.getJobs().queue(runnable);
    }

    public boolean isDone() {
        return this.getJobs().isDone();
    }

    private class Jobs {
        private Vector<Runnable> _queuedJobs = new Vector();
        private boolean _isActive;

        public synchronized void queue(Runnable runnable) {
            this._queuedJobs.add(runnable);
            this.notifyAll();
        }

        synchronized Runnable dequeue() {
            while (this._queuedJobs.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Runnable job = null;
            if (this._queuedJobs.size() > 0 && (job = this._queuedJobs.get(0)) != null) {
                this._queuedJobs.remove(0);
            }
            return job;
        }

        public synchronized boolean isActive() {
            return this._isActive;
        }

        public synchronized void setActive(boolean active) {
            this._isActive = active;
        }

        public synchronized boolean isDone() {
            return this._queuedJobs.size() == 0 && !this.isActive();
        }
    }
}

