/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.db.internal.vendor.DB2;
import org.eclipse.jpt.db.internal.vendor.Derby;
import org.eclipse.jpt.db.internal.vendor.HSQLDB;
import org.eclipse.jpt.db.internal.vendor.Informix;
import org.eclipse.jpt.db.internal.vendor.MaxDB;
import org.eclipse.jpt.db.internal.vendor.MySQL;
import org.eclipse.jpt.db.internal.vendor.Oracle;
import org.eclipse.jpt.db.internal.vendor.PostgreSQL;
import org.eclipse.jpt.db.internal.vendor.SQLServer;
import org.eclipse.jpt.db.internal.vendor.Sybase;
import org.eclipse.jpt.db.internal.vendor.UnrecognizedVendor;
import org.eclipse.jpt.db.internal.vendor.Vendor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VendorRepository {
    private final Vendor[] vendors = this.buildVendors();
    private static final VendorRepository INSTANCE = new VendorRepository();

    public static VendorRepository instance() {
        return INSTANCE;
    }

    private VendorRepository() {
    }

    private Vendor[] buildVendors() {
        ArrayList<Vendor> list = new ArrayList<Vendor>();
        this.addVendorsTo(list);
        return list.toArray(new Vendor[list.size()]);
    }

    private void addVendorsTo(ArrayList<Vendor> list) {
        this.addVendorTo(DB2.udb(), list);
        this.addVendorTo(DB2.udbISeries(), list);
        this.addVendorTo(DB2.udbZSeries(), list);
        this.addVendorTo(Derby.instance(), list);
        this.addVendorTo(HSQLDB.instance(), list);
        this.addVendorTo(Informix.instance(), list);
        this.addVendorTo(MaxDB.instance(), list);
        this.addVendorTo(MySQL.instance(), list);
        this.addVendorTo(Oracle.instance(), list);
        this.addVendorTo(PostgreSQL.instance(), list);
        this.addVendorTo(SQLServer.instance(), list);
        this.addVendorTo(Sybase.asa(), list);
        this.addVendorTo(Sybase.ase(), list);
        this.addVendorTo(Sybase.dtpVendorExtension(), list);
    }

    private void addVendorTo(Vendor vendor, ArrayList<Vendor> list) {
        String name = vendor.getDTPVendorName();
        Iterator<Vendor> stream = list.iterator();
        while (stream.hasNext()) {
            if (!stream.next().getDTPVendorName().equals(name)) continue;
            throw new IllegalArgumentException("Duplicate vendor: " + name);
        }
        list.add(vendor);
    }

    public Vendor getVendor(String dtpVendorName) {
        int i = this.vendors.length;
        while (i-- > 0) {
            Vendor vendor = this.vendors[i];
            if (!vendor.getDTPVendorName().equals(dtpVendorName)) continue;
            return vendor;
        }
        return UnrecognizedVendor.instance();
    }
}

