/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import org.eclipse.jpt.core.context.java.JavaBaseColumn;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaColumn
extends AbstractJavaBaseColumn<ColumnAnnotation>
implements JavaColumn {
    protected Integer specifiedLength;
    protected Integer specifiedPrecision;
    protected Integer specifiedScale;

    public GenericJavaColumn(JavaJpaContextNode parent, JavaBaseColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(ColumnAnnotation column) {
        super.initialize(column);
        this.specifiedLength = this.getResourceLength();
        this.specifiedPrecision = this.getResourcePrecision();
        this.specifiedScale = this.getResourceScale();
    }

    @Override
    public void update(ColumnAnnotation column) {
        super.update(column);
        this.setSpecifiedLength_(this.getResourceLength());
        this.setSpecifiedPrecision_(this.getResourcePrecision());
        this.setSpecifiedScale_(this.getResourceScale());
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return 255;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        ((ColumnAnnotation)this.getResourceColumn()).setLength(newSpecifiedLength);
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected Integer getResourceLength() {
        return ((ColumnAnnotation)this.getResourceColumn()).getLength();
    }

    @Override
    public int getPrecision() {
        return this.getSpecifiedPrecision() == null ? this.getDefaultPrecision() : this.getSpecifiedPrecision().intValue();
    }

    @Override
    public int getDefaultPrecision() {
        return 0;
    }

    @Override
    public Integer getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        ((ColumnAnnotation)this.getResourceColumn()).setPrecision(newSpecifiedPrecision);
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    protected void setSpecifiedPrecision_(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    protected Integer getResourcePrecision() {
        return ((ColumnAnnotation)this.getResourceColumn()).getPrecision();
    }

    @Override
    public int getScale() {
        return this.getSpecifiedScale() == null ? this.getDefaultScale() : this.getSpecifiedScale().intValue();
    }

    @Override
    public int getDefaultScale() {
        return 0;
    }

    @Override
    public Integer getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        ((ColumnAnnotation)this.getResourceColumn()).setScale(newSpecifiedScale);
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    protected void setSpecifiedScale_(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    protected Integer getResourceScale() {
        return ((ColumnAnnotation)this.getResourceColumn()).getScale();
    }
}

