/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.uriresolver.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.uriresolver.internal.URIResolverExtensionRegistry;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.osgi.framework.Bundle;

public class URIResolverExtensionRegistryReader {
    protected static final String EXTENSION_POINT_ID = "resolverExtensions";
    protected static final String TAG_NAME = "resolverExtension";
    protected static final String ATT_ID = "id";
    protected static final String ELEM_PROJECT_NATURE_ID = "projectNature";
    protected static final String ATT_RESOURCE_TYPE = "resourceType";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_STAGE = "stage";
    protected static final String VAL_STAGE_PRE = "prenormalization";
    protected static final String VAL_STAGE_POST = "postnormalization";
    protected static final String VAL_STAGE_PHYSICAL = "physical";
    protected static final String ATT_VALUE = "value";
    protected static final String ATT_PRIORITY = "priority";
    protected URIResolverExtensionRegistry registry;

    public URIResolverExtensionRegistryReader(URIResolverExtensionRegistry registry) {
        this.registry = registry;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(URIResolverPlugin.getInstance().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_NAME)) {
            String priority;
            String className = element.getAttribute(ATT_CLASS);
            String resourceType = element.getAttribute(ATT_RESOURCE_TYPE);
            String stage = element.getAttribute(ATT_STAGE);
            if (stage == null || stage.equals("")) {
                stage = VAL_STAGE_POST;
            }
            if ((priority = element.getAttribute(ATT_PRIORITY)) == null || priority.equals("")) {
                priority = "medium";
            }
            ArrayList<String> projectNatureIds = new ArrayList<String>();
            IConfigurationElement[] ids = element.getChildren(ELEM_PROJECT_NATURE_ID);
            int numids = ids.length;
            int i = 0;
            while (i < numids) {
                String tempid = ids[i].getAttribute(ATT_VALUE);
                if (tempid != null) {
                    projectNatureIds.add(tempid);
                }
                ++i;
            }
            if (className != null) {
                try {
                    String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
                    int stageint = 2;
                    if (stage.equalsIgnoreCase(VAL_STAGE_PRE)) {
                        stageint = 1;
                    } else if (stage.equalsIgnoreCase(VAL_STAGE_PHYSICAL)) {
                        stageint = 3;
                    }
                    this.registry.put(className, pluginId, projectNatureIds, resourceType, stageint, priority);
                }
                catch (Exception e) {
                    Bundle bundle = URIResolverPlugin.getInstance().getBundle();
                    Status status = new Status(4, bundle.getSymbolicName(), e.getMessage(), (Throwable)e);
                    Platform.getLog((Bundle)bundle).log((IStatus)status);
                }
            }
        }
    }
}

