/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CompleteEnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.CursorConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.model.IndentForEnter;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.IndentForEnterHelper;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextEditorPrefs;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.text.TMPartitions;

public class LanguageConfigurationAutoEditStrategy
implements IAutoEditStrategy {
    private static final IContentType[] EMPTY_CONTENT_TYPES = new IContentType[0];
    private IContentType[] contentTypes = EMPTY_CONTENT_TYPES;
    private @Nullable IDocument document;

    public void customizeDocumentCommand(IDocument doc, DocumentCommand command) {
        if (command.text.isEmpty()) {
            return;
        }
        if (!doc.equals(this.document)) {
            ContentTypeInfo contentTypeInfo = ContentTypeHelper.findContentTypes((IDocument)doc);
            this.contentTypes = contentTypeInfo == null ? EMPTY_CONTENT_TYPES : contentTypeInfo.getContentTypes();
            this.document = doc;
        }
        if (this.contentTypes.length == 0 || command.getCommandCount() > 1) {
            return;
        }
        IContentType[] effectiveContentTypes = this.contentTypes;
        IContentType[] tmPartitionContentTypes = TMPartitions.getContentTypesForOffset((IDocument)doc, (int)command.offset);
        if (tmPartitionContentTypes.length > 0) {
            effectiveContentTypes = tmPartitionContentTypes;
        }
        if (TextUtils.isEnter(doc, command)) {
            CursorConfiguration cursorCfg = TextEditorPrefs.getCursorConfiguration(UI.getActiveTextEditor());
            LanguageConfigurationAutoEditStrategy.onEnter(cursorCfg, doc, effectiveContentTypes, command);
            return;
        }
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        if (command.text.length() == 1) {
            IContentType contentType2;
            int n;
            int n2;
            IContentType[] iContentTypeArray;
            ITextSelection textSelection = UI.getActiveTextSelection();
            if (textSelection != null && textSelection.getLength() > 0) {
                iContentTypeArray = effectiveContentTypes;
                n2 = effectiveContentTypes.length;
                n = 0;
                while (n < n2) {
                    List<AutoClosingPair> surroundingPairs;
                    contentType2 = iContentTypeArray[n];
                    if (registry.shouldSurroundingPairs(contentType2) && !(surroundingPairs = registry.getSurroundingPairs(contentType2)).isEmpty()) {
                        for (AutoClosingPair pair : surroundingPairs) {
                            if (!command.text.equals(pair.open)) continue;
                            try {
                                command.addCommand(command.offset + textSelection.getLength(), 0, pair.close, null);
                                command.length = 0;
                                command.caretOffset = command.offset + textSelection.getLength() + pair.open.length();
                                command.shiftsCaret = false;
                            }
                            catch (BadLocationException ex) {
                                LanguageConfigurationPlugin.logError(ex);
                            }
                            return;
                        }
                    }
                    ++n;
                }
            }
            iContentTypeArray = effectiveContentTypes;
            n2 = effectiveContentTypes.length;
            n = 0;
            while (n < n2) {
                contentType2 = iContentTypeArray[n];
                AutoClosingPairConditional autoClosingPair = registry.getAutoClosingPair(doc.get(), command.offset, command.text, contentType2);
                if (autoClosingPair != null) {
                    command.caretOffset = command.offset + command.text.length();
                    command.shiftsCaret = false;
                    if (command.text.equals(autoClosingPair.open) && LanguageConfigurationAutoEditStrategy.isFollowedBy(doc, command.offset, autoClosingPair.open)) {
                        command.text = "";
                    } else if (command.text.equals(autoClosingPair.close) && LanguageConfigurationAutoEditStrategy.isFollowedBy(doc, command.offset, autoClosingPair.close)) {
                        command.text = "";
                    } else if (this.isAutoClosingAllowed(doc, contentType2, command.offset, autoClosingPair)) {
                        command.text = String.valueOf(command.text) + autoClosingPair.close;
                    }
                    return;
                }
                ++n;
            }
            if (Arrays.stream(this.contentTypes).flatMap(contentType -> registry.getEnabledAutoClosingPairs((IContentType)contentType).stream()).anyMatch(charPair -> charPair.close.equals(documentCommand.text) && LanguageConfigurationAutoEditStrategy.isFollowedBy(doc, documentCommand.offset, charPair.close))) {
                command.caretOffset = command.offset + command.text.length();
                command.shiftsCaret = false;
                command.text = "";
            }
        } else {
            CursorConfiguration cursorCfg = TextEditorPrefs.getCursorConfiguration(UI.getActiveTextEditor());
            IContentType[] iContentTypeArray = this.contentTypes;
            int n = this.contentTypes.length;
            int n3 = 0;
            while (n3 < n) {
                IContentType contentType3 = iContentTypeArray[n3];
                if (registry.shouldIndentForEnter(contentType3)) {
                    try {
                        boolean isPastedTextMultiLine = command.text.contains("\n");
                        int lineIndex = doc.getLineOfOffset(command.offset);
                        boolean isTargetLineBlank = TextUtils.isBlankLine(doc, lineIndex);
                        if (isPastedTextMultiLine || isTargetLineBlank) {
                            String newIndent;
                            boolean isWhitespaceOnlySingleLineInsert;
                            boolean bl = isWhitespaceOnlySingleLineInsert = !isPastedTextMultiLine && command.text.chars().allMatch(Character::isWhitespace);
                            if (!isWhitespaceOnlySingleLineInsert && (newIndent = registry.getGoodIndentForLine(doc, lineIndex, contentType3, IndentForEnterHelper.IIndentConverter.of(cursorCfg))) != null) {
                                int lineStartOffset = doc.getLineOffset(lineIndex);
                                int offsetInLine = command.offset - lineStartOffset;
                                if (offsetInLine > 0 && doc.get(lineStartOffset, offsetInLine).isBlank()) {
                                    command.offset = lineStartOffset;
                                    command.length += offsetInLine;
                                }
                                command.text = TextUtils.replaceIndent(command.text, cursorCfg.indentSize, cursorCfg.normalizeIndentation(newIndent), false).toString();
                                command.shiftsCaret = true;
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        LanguageConfigurationPlugin.logError(ex);
                    }
                }
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAutoClosingAllowed(IDocument doc, IContentType contentType, int offset, AutoClosingPairConditional pair) {
        try {
            LanguageConfigurationRegistryManager registry;
            char ch = doc.getChar(offset);
            if (!Character.isWhitespace(ch) && (registry = LanguageConfigurationRegistryManager.getInstance()).getAutoCloseBefore(contentType).indexOf(ch) < 0) {
                return false;
            }
        }
        catch (Exception ch) {
            // empty catch block
        }
        if (pair.notIn.isEmpty()) return true;
        TMDocumentModel docModel = TMModelManager.INSTANCE.connect(doc);
        try {
            String notIn;
            int lineIndex = doc.getLineOfOffset(offset);
            List tokens = docModel.getLineTokens(lineIndex);
            if (tokens == null) return true;
            int lineCharOffset = offset - doc.getLineOffset(lineIndex) - 1;
            TMToken tokenAtOffset = null;
            for (TMToken token : tokens) {
                if (token.startIndex > lineCharOffset) break;
                tokenAtOffset = token;
            }
            if (tokenAtOffset == null) return true;
            Iterator<Object> iterator = pair.notIn.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!tokenAtOffset.type.contains(notIn = (String)iterator.next()));
            return false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return true;
    }

    private static boolean isFollowedBy(IDocument doc, int offset, String value) {
        int i = 0;
        while (i < value.length()) {
            if (doc.getLength() <= offset) {
                return false;
            }
            try {
                if (doc.getChar(offset) != value.charAt(i)) {
                    return false;
                }
            }
            catch (BadLocationException e) {
                return false;
            }
            ++offset;
            ++i;
        }
        return true;
    }

    private static void onEnter(CursorConfiguration cursorCfg, IDocument doc, IContentType[] contentTypes, DocumentCommand command) {
        if (contentTypes.length > 0) {
            LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
            IContentType[] iContentTypeArray = contentTypes;
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IndentForEnter indentForEnter;
                CompleteEnterAction enterAction;
                IContentType contentType = iContentTypeArray[n2];
                if (registry.shouldEnterAction(contentType) && (enterAction = registry.getEnterAction(doc, command.offset, contentType)) != null) {
                    command.shiftsCaret = false;
                    String newLine = command.text;
                    switch (enterAction.indentAction) {
                        case None: {
                            String increasedIndent = cursorCfg.normalizeIndentation(enterAction.indentation + enterAction.appendText);
                            command.text = newLine + increasedIndent;
                            command.caretOffset = command.offset + command.text.length();
                            break;
                        }
                        case Indent: {
                            String increasedIndent = cursorCfg.normalizeIndentation(enterAction.indentation + enterAction.appendText);
                            command.text = newLine + increasedIndent;
                            command.caretOffset = command.offset + command.text.length();
                            break;
                        }
                        case IndentOutdent: {
                            String normalIndent = cursorCfg.normalizeIndentation(enterAction.indentation);
                            String increasedIndent = cursorCfg.normalizeIndentation(enterAction.indentation + enterAction.appendText);
                            command.text = newLine + increasedIndent + newLine + normalIndent;
                            command.caretOffset = command.offset + (newLine + increasedIndent).length();
                            break;
                        }
                        case Outdent: {
                            String indentation = TextUtils.getIndentationFromWhitespace(enterAction.indentation, cursorCfg);
                            String outdentedText = cursorCfg.outdentString(cursorCfg.normalizeIndentation(indentation + enterAction.appendText));
                            command.text = newLine + outdentedText;
                            command.caretOffset = command.offset + command.text.length();
                        }
                    }
                    return;
                }
                if (registry.shouldIndentForEnter(contentType) && (indentForEnter = registry.getIndentForEnter(doc, command.offset, contentType, IndentForEnterHelper.IIndentConverter.of(cursorCfg))) != null) {
                    String newLine = command.text;
                    command.text = newLine + cursorCfg.normalizeIndentation(indentForEnter.afterEnter);
                    command.caretOffset = command.offset;
                    return;
                }
                ++n2;
            }
        }
        new DefaultIndentLineAutoEditStrategy().customizeDocumentCommand(doc, command);
    }
}

