/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.utils;

import org.eclipse.tm4e.languageconfiguration.internal.utils.Strings;

public final class Indentation {
    private static String normalizeIndentationFromWhitespace(String text, int indentSize, boolean insertSpaces) {
        int spacesCnt = 0;
        int i = 0;
        while (i < text.length()) {
            spacesCnt = text.charAt(i) == '\t' ? Indentation.nextIndentTabStop(spacesCnt, indentSize) : ++spacesCnt;
            ++i;
        }
        StringBuilder result = new StringBuilder();
        if (!insertSpaces) {
            int tabsCnt = spacesCnt / indentSize;
            spacesCnt %= indentSize;
            int i2 = 0;
            while (i2 < tabsCnt) {
                result.append('\t');
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < spacesCnt) {
            result.append(' ');
            ++i3;
        }
        return result.toString();
    }

    public static String normalizeIndentation(String text, int indentSize, boolean insertSpaces) {
        int firstNonWhitespaceIdx = Strings.firstNonWhitespaceIndex(text);
        if (firstNonWhitespaceIdx == -1) {
            firstNonWhitespaceIdx = text.length();
        }
        return Indentation.normalizeIndentationFromWhitespace(text.substring(0, firstNonWhitespaceIdx), indentSize, insertSpaces) + text.substring(firstNonWhitespaceIdx);
    }

    private static int nextIndentTabStop(int visibleColumn, int indentSize) {
        return visibleColumn + indentSize - visibleColumn % indentSize;
    }

    private Indentation() {
    }
}

