/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.astro;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public final class AstroLanguageServer
extends ProcessStreamConnectionProvider {
    private static volatile String astroLanguageServerPath;
    private static volatile String typescriptSdkPath;

    private static Path resolveResource(String resourcePath) throws IOException {
        try {
            URL url = FileLocator.toFileURL((URL)AstroLanguageServer.class.getResource(resourcePath));
            return Paths.get(url.toURI()).toAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to resolve resource URI: " + resourcePath, ex);
        }
    }

    public AstroLanguageServer() throws IOException {
        try {
            if (astroLanguageServerPath == null || typescriptSdkPath == null) {
                astroLanguageServerPath = AstroLanguageServer.resolveResource("/node_modules/astro-vscode/dist/node/server.js").toString();
                typescriptSdkPath = AstroLanguageServer.resolveResource("/node_modules/typescript/lib").toString();
            }
            this.setCommands(List.of(NodeJSManager.getNodeJsLocation().getAbsolutePath(), astroLanguageServerPath, "--stdio"));
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, Object> getInitializationOptions(URI projectRootUri) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.setWorkingDirectory(projectRootUri.getRawPath());
        options.put("typescript", Collections.singletonMap("tsdk", typescriptSdkPath));
        options.put("contentIntellisense", true);
        return options;
    }
}

