/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.jsts;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.jsts.TypeScriptPlugin;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.JSTSLanguagePreferences;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.JSTSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.ui.preferences.ProcessStreamConnectionProviderWithPreference;

public class JSTSLanguageServer
extends ProcessStreamConnectionProviderWithPreference {
    public static final String JSTS_LANGUAGE_SERVER_ID = "org.eclipse.wildwebdeveloper.jsts";
    private static final String[] SUPPORTED_SECTIONS = new String[]{"typescript", "javascript"};
    private static String tsserverPath;

    public JSTSLanguageServer() {
        super(JSTS_LANGUAGE_SERVER_ID, Activator.getDefault().getPreferenceStore(), SUPPORTED_SECTIONS);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/typescript-language-server/lib/cli.mjs"));
            File nodeModules = new File(url.getPath()).getParentFile().getParentFile().getParentFile();
            tsserverPath = new File(nodeModules, "typescript/lib/tsserver.js").getAbsolutePath();
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    public Object getInitializationOptions(URI rootUri) {
        String maxTsServerMemory;
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList<TypeScriptPlugin> plugins = new ArrayList<TypeScriptPlugin>();
        try {
            plugins.add(new TypeScriptPlugin("typescript-plugin-css-modules"));
            plugins.add(new TypeScriptPlugin("typescript-lit-html-plugin"));
            plugins.add(new TypeScriptPlugin("@vue/typescript-plugin", "@vue/language-server", new String[]{"vue"}));
            options.put("plugins", plugins.stream().map(TypeScriptPlugin::toMap).toArray());
            if (!"Project version".equals(JSTSPreferenceServerConstants.getTypeScriptVersion())) {
                HashMap<String, String> tsServer = new HashMap<String, String>();
                tsServer.put("path", tsserverPath);
                tsServer.put("nodePath", NodeJSManager.getNodeJsLocation().getAbsolutePath());
                options.put("tsserver", tsServer);
            }
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
        if ((maxTsServerMemory = System.getProperty("org.eclipse.wildwebdeveloper.maxTsServerMemory")) != null) {
            options.put("maxTsServerMemory", maxTsServerMemory);
        }
        options.put("disableAutomaticTypingAcquisition", true);
        options.put("hostInfo", "Eclipse");
        options.put("watchOptions", new HashMap());
        return options;
    }

    @Override
    protected Object createSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.putAll(JSTSLanguagePreferences.JS.getGlobalSettings());
        settings.putAll(JSTSLanguagePreferences.TS.getGlobalSettings());
        return settings;
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(this.createSettings());
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }
}

