"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var he_1 = require("he");
var node_1 = __importDefault(require("./node"));
var type_1 = __importDefault(require("./type"));
/**
 * TextNode to contain a text element in DOM tree.
 * @param {string} value [description]
 */
var TextNode = /** @class */ (function (_super) {
    __extends(TextNode, _super);
    function TextNode(rawText, parentNode, range) {
        if (parentNode === void 0) { parentNode = null; }
        var _this = _super.call(this, parentNode, range) || this;
        /**
         * Node Type declaration.
         * @type {Number}
         */
        _this.nodeType = type_1.default.TEXT_NODE;
        _this.rawTagName = '';
        _this._rawText = rawText;
        return _this;
    }
    TextNode.prototype.clone = function () {
        return new TextNode(this._rawText, null);
    };
    Object.defineProperty(TextNode.prototype, "rawText", {
        get: function () {
            return this._rawText;
        },
        /**
         * Set rawText and invalidate trimmed caches
         */
        set: function (text) {
            this._rawText = text;
            this._trimmedRawText = void 0;
            this._trimmedText = void 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextNode.prototype, "trimmedRawText", {
        /**
         * Returns raw text with all whitespace trimmed except single leading/trailing non-breaking space
         */
        get: function () {
            if (this._trimmedRawText !== undefined)
                return this._trimmedRawText;
            this._trimmedRawText = trimText(this.rawText);
            return this._trimmedRawText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextNode.prototype, "trimmedText", {
        /**
         * Returns text with all whitespace trimmed except single leading/trailing non-breaking space
         */
        get: function () {
            if (this._trimmedText !== undefined)
                return this._trimmedText;
            this._trimmedText = trimText(this.text);
            return this._trimmedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextNode.prototype, "text", {
        /**
         * Get unescaped text value of current node and its children.
         * @return {string} text content
         */
        get: function () {
            return (0, he_1.decode)(this.rawText);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextNode.prototype, "isWhitespace", {
        /**
         * Detect if the node contains only white space.
         * @return {boolean}
         */
        get: function () {
            return /^(\s|&nbsp;)*$/.test(this.rawText);
        },
        enumerable: false,
        configurable: true
    });
    TextNode.prototype.toString = function () {
        return this.rawText;
    };
    return TextNode;
}(node_1.default));
exports.default = TextNode;
/**
 * Trim whitespace except single leading/trailing non-breaking space
 */
function trimText(text) {
    var i = 0;
    var startPos;
    var endPos;
    while (i >= 0 && i < text.length) {
        if (/\S/.test(text[i])) {
            if (startPos === undefined) {
                startPos = i;
                i = text.length;
            }
            else {
                endPos = i;
                i = void 0;
            }
        }
        if (startPos === undefined)
            i++;
        else
            i--;
    }
    if (startPos === undefined)
        startPos = 0;
    if (endPos === undefined)
        endPos = text.length - 1;
    var hasLeadingSpace = startPos > 0 && /[^\S\r\n]/.test(text[startPos - 1]);
    var hasTrailingSpace = endPos < (text.length - 1) && /[^\S\r\n]/.test(text[endPos + 1]);
    return (hasLeadingSpace ? ' ' : '') + text.slice(startPos, endPos + 1) + (hasTrailingSpace ? ' ' : '');
}
