/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GDSLayers {
    private List normalLayers = new ArrayList();
    private int pinLayer = -1;
    private int textLayer = -1;

    public int getNumLayers() {
        return this.normalLayers.size();
    }

    public Iterator getLayers() {
        return this.normalLayers.iterator();
    }

    public Integer getFirstLayer() {
        if (this.normalLayers.size() == 0) {
            return new Integer(0);
        }
        return (Integer)this.normalLayers.get(0);
    }

    public int getPinLayer() {
        return this.pinLayer;
    }

    public int getTextLayer() {
        return this.textLayer;
    }

    public static GDSLayers parseLayerString(String string) {
        String trimmed;
        GDSLayers answers = new GDSLayers();
        while ((trimmed = string.trim()).length() != 0) {
            int number;
            int slashPos = trimmed.indexOf(47);
            int endPos = trimmed.indexOf(44);
            if (endPos < 0) {
                endPos = trimmed.length();
            }
            if ((number = TextUtils.atoi(trimmed)) != 0 || trimmed.equals("0")) {
                char lastCh;
                int type = 0;
                if (slashPos >= 0 && slashPos < endPos) {
                    type = TextUtils.atoi(trimmed.substring(slashPos + 1));
                }
                if ((lastCh = trimmed.charAt(endPos - 1)) == 't') {
                    answers.textLayer = number | type << 16;
                } else if (lastCh == 'p') {
                    answers.pinLayer = number | type << 16;
                } else {
                    Integer normalLayer = new Integer(number | type << 16);
                    answers.normalLayers.add(normalLayer);
                }
                if (endPos == trimmed.length()) break;
            }
            string = trimmed.substring(endPos + 1);
        }
        return answers;
    }
}

