/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.Main;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.bool.LayoutMergerHierImpl;
import com.sun.electric.database.geometry.bool.UnloadPolys;
import com.sun.electric.database.geometry.bool.VectorCache;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class Main {
    static void initElectric() {
        TextDescriptor.cacheSize();
        Tool.initAllTools();
        Pref.lockCreation();
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
        Job.setUserInterface(new Main.UserInterfaceDummy(){

            @Override
            public EDatabase getDatabase() {
                return EDatabase.serverDatabase();
            }

            @Override
            public Cell getCurrentCell() {
                return null;
            }
        });
        EDatabase.setServerDatabase(database);
        database.lock(true);
        Technology.initPreinstalledTechnologies(database, Technology.getParamValuesByXmlPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Library loadLibrary(String libPath) {
        EDatabase database = EDatabase.serverDatabase();
        database.lowLevelBeginChanging(null);
        try {
            URL libUrl = TextUtils.makeURLToFile(libPath);
            String libName = TextUtils.getFileNameWithoutExtension(libUrl);
            FileType fileType = libPath.endsWith(".delib") ? FileType.DELIB : FileType.JELIB;
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            Library library = LibraryFiles.readLibrary(ep, libUrl, libName, fileType, true);
            return library;
        }
        finally {
            database.backup();
            database.lowLevelEndChanging();
        }
    }

    static Cell loadCell(String libFile, String cellName) {
        return Main.loadLibrary(libFile).findNodeProto(cellName);
    }

    static int countHier(CellTree top, CellTreeFun localCount) {
        int sum2 = 0;
        for (CellTree t : Main.downTop(top)) {
            sum2 += localCount.apply(t);
        }
        return sum2;
    }

    static Map<CellId, Integer> countFlat(CellTree top, CellTreeFun localCount) {
        Collection<CellTree> cells = Main.downTop(top);
        LinkedHashMap<CellId, Integer> result2 = new LinkedHashMap<CellId, Integer>();
        for (CellTree t : cells) {
            ArrayList<ImmutableNodeInst> nodes = new ArrayList<ImmutableNodeInst>();
            for (ImmutableNodeInst n : t.top.cellRevision.nodes) {
                if (!(n.protoId instanceof CellId)) continue;
                nodes.add(n);
            }
            int c = localCount.apply(t);
            for (ImmutableNodeInst n : nodes) {
                c += ((Integer)result2.get((CellId)n.protoId)).intValue();
            }
            result2.put(t.top.cellRevision.d.cellId, c);
        }
        return result2;
    }

    static Collection<CellTree> downTop(CellTree top) {
        LinkedHashSet<CellTree> result2 = new LinkedHashSet<CellTree>();
        Main.downTop(top, result2);
        return result2;
    }

    private static void downTop(CellTree t, Collection<CellTree> result2) {
        if (!result2.contains(t)) {
            for (CellTree subTree : t.getSubTrees()) {
                Main.downTop(subTree, result2);
            }
            result2.add(t);
        }
    }

    static Iterable<PolyBase.PolyBaseTree> byteArray2tree(byte[] ba) throws IOException {
        DataInputStream inpS = new DataInputStream(new ByteArrayInputStream(ba));
        UnloadPolys up = new UnloadPolys();
        Iterable<PolyBase.PolyBaseTree> trees = up.loop(inpS, false);
        inpS.close();
        return trees;
    }

    static int treesSize(Iterable<PolyBase.PolyBaseTree> ts, PolyBaseFun localCount) {
        int sum2 = 0;
        for (PolyBase.PolyBaseTree t : ts) {
            sum2 += Main.treeSize(t, localCount);
        }
        return sum2;
    }

    static int treeSize(PolyBase.PolyBaseTree t, PolyBaseFun localCount) {
        Iterable<PolyBase.PolyBaseTree> l = t.getSons();
        int sonCount = Main.treesSize(l, localCount);
        return localCount.apply(t.getPoly()) + sonCount;
    }

    static void hugeFile() throws IOException {
        File file = File.createTempFile("Electric", "DRC", new File("."));
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        byte[] b = new byte[0x100000];
        for (int i = 0; i < 8000; ++i) {
            out.write(b);
        }
        out.close();
        file.delete();
    }

    static int countHier(Cell topCell, final CellRevisionFun localCount) {
        return Main.countHier(topCell.tree(), new CellTreeFun(){

            @Override
            public int apply(CellTree t) {
                return localCount.apply(t.top.cellRevision);
            }
        });
    }

    static int countFlat(Cell topCell, final CellRevisionFun localCount) {
        return Main.countFlat(topCell.tree(), new CellTreeFun(){

            @Override
            public int apply(CellTree t) {
                return localCount.apply(t.top.cellRevision);
            }
        }).get(topCell.getId());
    }

    public static void main(String[] args) throws IOException {
        Main.initElectric();
        String libPath = args[0];
        String topCellName = args[1];
        Cell topCell = Main.loadCell(libPath, topCellName);
        LayoutMergerHierImpl layoutMerger = new LayoutMergerHierImpl(topCell);
        Collection<CellTree> dt = Main.downTop(topCell.tree());
        assert (dt.equals(layoutMerger.downTop(topCell.tree())));
        System.out.println("downTop " + dt.size());
        for (CellTree t : dt) {
            System.out.println(t);
        }
        final VectorCache vectorCache = layoutMerger.vectorCache;
        System.out.println(Main.countHier(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return 1;
            }
        }) + " cells");
        System.out.println(Main.countHier(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return vectorCache.getSubcells(r.d.cellId).size();
            }
        }) + " subCells");
        System.out.println(Main.countHier(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.nodes.size();
            }
        }) + " nodes");
        System.out.println(Main.countHier(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.arcs.size();
            }
        }) + " arcs");
        System.out.println(Main.countHier(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.exports.size();
            }
        }) + " exports");
        System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return 1;
            }
        }) + " cell insts");
        System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return vectorCache.getSubcells(r.d.cellId).size();
            }
        }) + " subCells");
        System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.nodes.size();
            }
        }) + " node insts");
        System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.arcs.size();
            }
        }) + " arc insts");
        System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

            @Override
            public int apply(CellRevision r) {
                return r.exports.size();
            }
        }) + " export insts");
        vectorCache.scanLayers(topCell.getId());
        Collection<Layer> layers = vectorCache.getLayers();
        for (final Layer layer : layers) {
            System.out.println();
            System.out.println(layer);
            System.out.println(Main.countHier(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return vectorCache.getNumBoxes(r.d.cellId, layer) * 4;
                }
            }) + " points");
            System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return vectorCache.getNumBoxes(r.d.cellId, layer) * 4;
                }
            }) + " point insts");
            final LinkedHashMap<CellId, Iterable<PolyBase.PolyBaseTree>> mergedTrees = new LinkedHashMap<CellId, Iterable<PolyBase.PolyBaseTree>>();
            LinkedHashMap<CellId, int[]> mergedCoords = new LinkedHashMap<CellId, int[]>();
            for (CellTree t : dt) {
                CellId cellId = t.top.cellRevision.d.cellId;
                byte[] ba = layoutMerger.mergeLocalLayerToByteArray(cellId, layer);
                if (ba != null) {
                    mergedTrees.put(cellId, Main.byteArray2tree(ba));
                    mergedCoords.put(cellId, layoutMerger.byteArray2coordArray(ba));
                    continue;
                }
                mergedTrees.put(cellId, Collections.emptyList());
                mergedCoords.put(cellId, new int[0]);
            }
            System.out.println(Main.countHier(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return Main.treesSize((Iterable)mergedTrees.get(r.d.cellId), new PolyBaseFun(){

                        @Override
                        public int apply(PolyBase p) {
                            return 1;
                        }
                    });
                }
            }) + " merged polygons");
            System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return Main.treesSize((Iterable)mergedTrees.get(r.d.cellId), new PolyBaseFun(){

                        @Override
                        public int apply(PolyBase p) {
                            return 1;
                        }
                    });
                }
            }) + " merged polygon insts");
            System.out.println(Main.countHier(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return Main.treesSize((Iterable)mergedTrees.get(r.d.cellId), new PolyBaseFun(){

                        @Override
                        public int apply(PolyBase p) {
                            return p.getPoints().length;
                        }
                    });
                }
            }) + " merged points");
            System.out.println(Main.countFlat(topCell, new CellRevisionFun(){

                @Override
                public int apply(CellRevision r) {
                    return Main.treesSize((Iterable)mergedTrees.get(r.d.cellId), new PolyBaseFun(){

                        @Override
                        public int apply(PolyBase p) {
                            return p.getPoints().length;
                        }
                    });
                }
            }) + " merged point insts");
            boolean rotate = false;
            String fileName = layer.getName() + ".dm";
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            out.writeBoolean(rotate);
            layoutMerger.mergeLayer(mergedCoords, topCell.getId(), layer, rotate, out);
            out.close();
            DataInputStream inpS = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            assert (inpS.readBoolean() == rotate);
            UnloadPolys up = new UnloadPolys();
            Iterable<PolyBase.PolyBaseTree> trees = up.loop(inpS, false);
            System.out.println(Main.treesSize(trees, new PolyBaseFun(){

                @Override
                public int apply(PolyBase p) {
                    return 1;
                }
            }) + " merged polygons");
            System.out.println(Main.treesSize(trees, new PolyBaseFun(){

                @Override
                public int apply(PolyBase p) {
                    return p.getPoints().length;
                }
            }) + " merged polygons");
            inpS.close();
        }
    }

    static interface PolyBaseFun {
        public int apply(PolyBase var1);
    }

    static interface CellRevisionFun {
        public int apply(CellRevision var1);
    }

    static interface CellTreeFun {
        public int apply(CellTree var1);
    }
}

