/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.FakeTestJob;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;

public abstract class AbstractTest
implements Serializable {
    private String name;
    private String groupName;
    private boolean multiTask;
    private boolean interactive;
    private FakeTestJob starterJob;

    static String properDirectory(String regressionPath, Class theClass) {
        String firstName = theClass.getName();
        int j = firstName.lastIndexOf(".");
        String type = firstName.substring(j + 1);
        int k = type.lastIndexOf("Test");
        type = type.substring(0, k);
        AbstractTest.dirMakeCheck(regressionPath, type);
        return type;
    }

    static String outputDir(String regressionPath, String testType) {
        return AbstractTest.workingDir(regressionPath, testType) + "output/";
    }

    static void ensureOutputDirectory(String dirName) {
        File f = new File(dirName);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    private static void dirMakeCheck(String regressionPath, String type) {
        boolean dirCheck = new File(AbstractTest.outputDir(regressionPath, type)).isDirectory();
        if (!dirCheck) {
            boolean dirMake = new File(AbstractTest.outputDir(regressionPath, type)).mkdir();
            if (dirMake) {
                System.out.println("Successfully made directory: " + AbstractTest.outputDir(regressionPath, type));
            } else {
                System.out.println("Failed to make directory");
            }
        }
    }

    protected static String workingDir(String regressionPath, String testType) {
        String path = regressionPath;
        if (path != null && path.length() != 0 && !path.contains("<")) {
            return regressionPath + "/tools/" + testType + "/";
        }
        return "";
    }

    protected static String dataDir(String regressionPath, String testType) {
        return AbstractTest.workingDir(regressionPath, testType) + "data/libs/";
    }

    public static void wipeLibraries() {
        Clipboard.clear();
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            allLibs.add(it.next());
        }
        while (allLibs.size() != 0) {
            boolean killedOne = false;
            for (Library lib : allLibs) {
                Set<Cell> found = Library.findReferenceInCell(lib);
                boolean nonClipboard = false;
                for (Cell cell : found) {
                    if (cell.getLibrary().isHidden()) continue;
                    nonClipboard = true;
                }
                if (nonClipboard) continue;
                WindowFrame.removeLibraryReferences(lib);
                lib.kill("delete");
                allLibs.remove(lib);
                killedOne = true;
                break;
            }
            if (killedOne) continue;
            System.out.println("Circular loop in libraries: cannot wipe");
            break;
        }
    }

    protected AbstractTest(String name) {
        this.name = name;
        this.multiTask = false;
        this.interactive = false;
    }

    protected AbstractTest(String name, boolean multiTask, boolean interactive) {
        this.name = name;
        this.multiTask = multiTask;
        this.interactive = interactive;
    }

    static String getValidRootPath(String root, String extraPath, String alternativePath) {
        return root != null ? root + extraPath : alternativePath;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public String getFunctionName() {
        return this.name;
    }

    protected String getResultName() {
        return this.getFunctionName() + "Result";
    }

    protected String getLogName() {
        return this.getFunctionName() + "Out.log";
    }

    public String getFullTestName() {
        return this.groupName + ":" + this.name;
    }

    boolean isMultiTask() {
        return this.multiTask;
    }

    boolean isInteractive() {
        return this.interactive;
    }

    void setStarterJob(FakeTestJob starterJob) {
        this.starterJob = starterJob;
    }

    FakeTestJob getStarterJob() {
        return this.starterJob;
    }

    EDatabase getDatabase() {
        return this.starterJob.getDatabase();
    }

    String getRegressionPath() {
        return User.getRegressionPath();
    }

    protected String workingDir() {
        String path = this.getRegressionPath();
        String testParameter = AbstractTest.properDirectory(path, this.getClass());
        return AbstractTest.workingDir(path, testParameter);
    }

    public String toString() {
        return this.name;
    }

    protected static Technology setFoundry(Technology tech) {
        Foundry.Type f = null;
        if (tech != Technology.getMocmosTechnology()) {
            System.out.println(f + " not available for testing");
            return tech;
        }
        f = Foundry.Type.MOSIS;
        return AbstractTest.setFoundry(tech, f.getName());
    }

    public static Technology setFoundry(Technology tech, String foundryName) {
        String techName = tech.getTechName();
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        changeBatch.add(tech.getPrefFoundrySetting(), foundryName);
        EDatabase.serverDatabase().implementSettingChanges(changeBatch);
        return Technology.findTechnology(techName);
    }

    static boolean compareLibraryResults(String trueRootPath, String rootName, Library outLib, char[] lineKeys) {
        String commondEnd = rootName + "Result";
        String outputDir = trueRootPath + "output/";
        String destLibName = outputDir + commondEnd + ".jelib";
        Output.saveJelib(destLibName, outLib);
        String trimmedLib = outputDir + commondEnd + "Partial.jelib";
        AbstractTest.removeLines(destLibName, trimmedLib, lineKeys);
        String expectedLib = trueRootPath + "data/expected/" + commondEnd + ".jelib";
        return AbstractTest.compareResults(trimmedLib, expectedLib);
    }

    boolean compareCellResults(Cell cell, String resultName) {
        if (resultName == null) {
            resultName = this.getResultName();
        }
        String testParameter = AbstractTest.properDirectory(this.getRegressionPath(), this.getClass());
        String outputDir = AbstractTest.outputDir(this.getRegressionPath(), testParameter);
        cell.lowLevelSetRevisionDate(new Date(0L));
        cell.getDatabase().backup();
        String destLib = outputDir + resultName + "Out.jelib";
        Output.saveJelib(destLib, cell.getLibrary());
        String trimmedLib = outputDir + resultName + ".jelib";
        AbstractTest.trimLibToCell(destLib, trimmedLib, cell.getName() + ";");
        String expectedLib = AbstractTest.workingDir(this.getRegressionPath(), testParameter) + "data/expected/" + resultName + ".jelib";
        return AbstractTest.compareResults(trimmedLib, expectedLib);
    }

    static void trimLibToCell(String inLibFile, String outLibFile, String cellName) {
        try {
            String buf;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(inLibFile));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLibFile)));
            boolean inCell = false;
            while ((buf = lineReader.readLine()) != null) {
                if (!inCell && buf.startsWith("C") && buf.substring(1).startsWith(cellName)) {
                    inCell = true;
                }
                if (inCell) {
                    printWriter.println(buf);
                }
                if (!buf.startsWith("X")) continue;
                inCell = false;
            }
            printWriter.close();
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + inLibFile);
            return;
        }
    }

    public static void removeLines(String inLibFile, String outLibFile, String key) {
        try {
            String buf;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(inLibFile));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLibFile)));
            while ((buf = lineReader.readLine()) != null) {
                if (buf.length() == 0 || buf.startsWith(key)) continue;
                printWriter.println(buf);
            }
            printWriter.close();
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + inLibFile);
            return;
        }
    }

    public static void removeLines(String inLibFile, String outLibFile, char[] lineKeys) {
        try {
            String buf;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(inLibFile));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLibFile)));
            while ((buf = lineReader.readLine()) != null) {
                if (buf.length() == 0) continue;
                char key = buf.charAt(0);
                boolean found = false;
                for (int i = 0; i < lineKeys.length; ++i) {
                    if (lineKeys[i] != key) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                printWriter.println(buf);
            }
            printWriter.close();
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + inLibFile);
            return;
        }
    }

    public static boolean compareResults(String file1, String file2) {
        String reason = null;
        LineNumberReader lineReader1 = null;
        try {
            lineReader1 = new LineNumberReader(new FileReader(file1));
        }
        catch (IOException e) {
            System.out.println("Cannot find file " + file1);
            return false;
        }
        LineNumberReader lineReader2 = null;
        try {
            lineReader2 = new LineNumberReader(new FileReader(file2));
        }
        catch (IOException e) {
            System.out.println("Cannot find file " + file2);
            try {
                lineReader1.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            return false;
        }
        try {
            block10: {
                String buf2;
                String buf1;
                do {
                    buf1 = lineReader1.readLine();
                    buf2 = lineReader2.readLine();
                    if (buf1 == null && buf2 == null) break block10;
                    if (buf1 != null && buf2 != null) continue;
                    reason = "Files have unequal length";
                    break block10;
                } while (buf1.equals(buf2));
                reason = "Line " + lineReader1.getLineNumber() + " differs";
            }
            lineReader1.close();
            lineReader2.close();
        }
        catch (IOException e) {
            System.out.println("Error reading files");
            return false;
        }
        if (reason != null) {
            System.out.println("*** EXPECTED RESULTS IN " + file2 + " DO NOT MATCH " + file1 + ": " + reason);
        }
        return reason == null;
    }

    public static boolean compareImages(int index, String file, String exFile) {
        BufferedImage exImage;
        BufferedImage image;
        String panelName = index < 0 ? "" : " Panel " + index;
        try {
            image = ImageIO.read(TextUtils.makeURLToFile(file));
        }
        catch (IOException e) {
            System.out.println("ERROR Reading " + file + " (" + e.getMessage() + ")");
            return false;
        }
        try {
            exImage = ImageIO.read(TextUtils.makeURLToFile(exFile));
        }
        catch (IOException e) {
            System.out.println("ERROR Reading " + exFile + " (" + e.getMessage() + ")");
            return false;
        }
        int wid = image.getWidth(null);
        int hei = image.getHeight(null);
        int exWid = exImage.getWidth(null);
        int exHei = exImage.getHeight(null);
        double ratioX = 1.0;
        double ratioY = 1.0;
        if (wid != exWid || hei != exHei) {
            System.out.println("WARNING:" + panelName + " image in file " + file + " does not match expected image in file " + exFile);
            System.out.println("        " + panelName + " image is " + wid + "x" + hei + " but expected image is " + exWid + "x" + exHei);
            if (wid != exWid) {
                ratioX = (double)exWid / (double)wid;
            }
            if (hei != exHei) {
                ratioY = (double)exHei / (double)hei;
            }
        }
        for (int y = 0; y < hei; ++y) {
            int trueY = (int)Math.round((double)y * ratioY);
            for (int x = 0; x < wid; ++x) {
                int exC;
                int trueX = (int)Math.round((double)x * ratioX);
                int c = image.getRGB(x, y) & 0xFFFFFF;
                if (c == (exC = exImage.getRGB(trueX, trueY) & 0xFFFFFF)) continue;
                String msg = "ERROR: ";
                if (wid == exWid && hei == exHei) {
                    System.out.println(msg + panelName + " image in file " + file + " does not match expected image in file " + exFile);
                    msg = "";
                }
                System.out.println(msg + "First pixel difference is at (" + x + "," + y + ") where color is " + (c >> 16 & 0xFF) + "/" + (c >> 8 & 0xFF) + "/" + (c & 0xFF) + " but expected color at (" + trueX + "," + trueY + ") is " + (exC >> 16 & 0xFF) + "/" + (exC >> 8 & 0xFF) + "/" + (exC & 0xFF));
                return false;
            }
        }
        return true;
    }

    String createMessageOutput() {
        String testParameter = AbstractTest.properDirectory(this.getRegressionPath(), this.getClass());
        String outputDir = AbstractTest.outputDir(this.getRegressionPath(), testParameter);
        AbstractTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + this.getLogName());
        return testParameter;
    }

    protected class CompareJob
    extends Job {
        private Cell cell;
        private String resultName;

        CompareJob(Cell cell) {
            this(cell, abstractTest.getResultName());
        }

        CompareJob(Cell cell, String resultName) {
            super("Test " + AbstractTest.this.getFullTestName() + " compare", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.resultName = resultName;
        }

        @Override
        public boolean doIt() {
            boolean good = false;
            try {
                good = AbstractTest.this.compareCellResults(this.cell, this.resultName);
            }
            catch (Exception e) {
                System.out.println("Exception:" + e);
                e.printStackTrace();
            }
            if (AbstractTest.this.getStarterJob() != null) {
                AbstractTest.this.getStarterJob().updateTestResult(good);
            }
            return good;
        }
    }
}

