/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.JPMSArgs;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;

public class StartEnvironment {
    private final String _name;
    private final BaseHome _baseHome;
    private final Props _properties = new Props();
    private final List<Path> _propertyFiles = new ArrayList<Path>();
    private final Classpath _libs = new Classpath();
    private final List<Path> _xmls = new ArrayList<Path>();
    private final List<String> _cmdLineXmls = new ArrayList<String>();
    private final List<String> _cmdLinePropertyFiles = new ArrayList<String>();
    private final List<String> _cmdLineLibs = new ArrayList<String>();
    private final JPMSArgs _jpmsArgs = new JPMSArgs();

    StartEnvironment(String name, BaseHome baseHome) {
        this._name = name;
        this._baseHome = baseHome;
    }

    BaseHome getBaseHome() {
        return this._baseHome;
    }

    void addCmdLineLib(String lib) {
        this._cmdLineLibs.add(lib);
    }

    void addCmdLinePropertyFile(String arg) {
        if (!this._cmdLinePropertyFiles.contains(arg)) {
            this._cmdLinePropertyFiles.add(arg);
        }
    }

    private void addUniquePropertyFile(String propertyFileRef, Path propertyFile) throws IOException {
        if (!"Jetty".equalsIgnoreCase(this.getName())) {
            throw new IllegalStateException("Property files not supported in environment " + this.getName());
        }
        if (!FS.canReadFile(propertyFile)) {
            throw new IOException("Cannot read file: " + propertyFileRef);
        }
        if (!this._propertyFiles.contains(propertyFile = FS.toRealPath(propertyFile))) {
            this._propertyFiles.add(propertyFile);
        }
    }

    public void addUniqueXmlFile(String xmlRef, Path xmlfile) throws IOException {
        if (!FS.canReadFile(xmlfile)) {
            throw new IOException("Cannot read file: " + xmlRef);
        }
        xmlfile = FS.toRealPath(xmlfile);
        if (!this.getXmlFiles().contains(xmlfile)) {
            this.getXmlFiles().add(xmlfile);
        }
    }

    public void addCmdLineXml(String arg) {
        if (!this._cmdLineXmls.contains(arg)) {
            this._cmdLineXmls.add(arg);
        }
    }

    public void dumpActiveXmls(PrintStream out) {
        out.println();
        out.printf("Active XMLs: %s%n", this._name);
        out.printf("-------------%s%n", "-".repeat(this._name.length()));
        if (this.getXmlFiles().isEmpty()) {
            out.println(" (no xml files specified)");
            return;
        }
        for (Path xml : this.getXmlFiles()) {
            out.printf(" %s%n", this._baseHome.toShortForm(xml.toAbsolutePath()));
        }
    }

    public void dumpProperties(PrintStream out) {
        out.println();
        out.printf("Properties: %s%n", this._name);
        out.printf("------------%s%n", "-".repeat(this._name.length()));
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Props.Prop prop : this._properties) {
            if (prop.source.equals("<system-property>")) continue;
            sortedKeys.add(prop.key);
        }
        if (sortedKeys.isEmpty()) {
            out.println(" (no properties specified)");
            return;
        }
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpProperty(out, key);
        }
        for (Path path : this._propertyFiles) {
            String p = this._baseHome.toShortForm(path);
            if (Files.isReadable(path)) {
                Properties props = new Properties();
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(in);
                    for (Object key : props.keySet()) {
                        out.printf(" %s:%s = %s%n", p, key, props.getProperty(String.valueOf(key)));
                    }
                }
                catch (Throwable th) {
                    out.printf(" %s NOT READABLE!%n", p);
                }
                continue;
            }
            out.printf(" %s NOT READABLE!%n", p);
        }
    }

    public Classpath getClasspath() {
        return this._libs;
    }

    public String getName() {
        return this._name;
    }

    public Props getProperties() {
        return this._properties;
    }

    public List<Path> getXmlFiles() {
        return this._xmls;
    }

    public void resolve() throws IOException {
        this.resolveExtraXmls();
        this.resolvePropertyFiles();
    }

    public void resolveLibs() throws IOException {
        StartLog.debug("Expanding Libs", new Object[0]);
        for (String cmdLineLib : this._cmdLineLibs) {
            StartLog.debug("cmdLineLib = %s", cmdLineLib);
            String lib = this.getProperties().expand(cmdLineLib);
            StartLog.debug("expanded = %s", lib);
            lib = lib.replaceAll("\\\\([^\\\\])", "\\\\\\\\$1");
            for (Path libPath : this._baseHome.getPaths(lib)) {
                this.getClasspath().addComponent(libPath);
            }
        }
    }

    private void resolveExtraXmls() throws IOException {
        for (String xmlRef : this._cmdLineXmls) {
            Path xmlfile = this._baseHome.getPath(xmlRef);
            if (!FS.exists(xmlfile)) {
                xmlfile = this._baseHome.getPath("etc/" + xmlRef);
            }
            this.addUniqueXmlFile(xmlRef, xmlfile);
        }
    }

    private void resolvePropertyFiles() throws IOException {
        for (String cmdLinePropertyFile : this._cmdLinePropertyFiles) {
            Path propertyFile = this._baseHome.getPath(cmdLinePropertyFile);
            if (!FS.exists(propertyFile)) {
                propertyFile = this._baseHome.getPath("etc/" + cmdLinePropertyFile);
            }
            this.addUniquePropertyFile(cmdLinePropertyFile, propertyFile);
        }
    }

    protected void dumpProperty(PrintStream out, String key) {
        Props.Prop prop = this._properties.getProp(key);
        if (prop == null) {
            out.printf(" %s (not defined)%n", key);
        } else {
            out.printf(" %s = %s%n", key, prop.value);
            if (StartLog.isDebugEnabled()) {
                out.printf("   origin: %s%n", prop.source);
            }
        }
    }

    protected List<Path> getPropertyFiles() {
        return this._propertyFiles;
    }

    void resolveJPMS(Module module) throws IOException {
        this._jpmsArgs.collect(module, this);
    }

    JPMSArgs getJPMSArgs() {
        return this._jpmsArgs;
    }

    public String toString() {
        return "%s@%x{%s,%s,%s,%s,%s}".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getClasspath(), this.getXmlFiles(), this.getProperties(), this.getPropertyFiles());
    }
}

