#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

//-----------------------------------------------------------------------------------------------
//	To port a GIMP filter,
//
//		Update DoIt
//		
//-----------------------------------------------------------------------------------------------
typedef struct {
    gdouble spread_amount_x;
    gdouble spread_amount_y;
} SpreadValues;

extern "C" SpreadValues		spvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper1, *fHelper2;
	ReturnValue			*fReturn;
	SpreadValues		fVals;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("spread") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fVals = spvals;
	fPreview = true;
	Lock ();
	fHelper1 = new BSliderTextHelper ("Sl1", "TE1", this); fHelper1->SetValue (fVals.spread_amount_x);
	fHelper2 = new BSliderTextHelper ("Sl2", "TE2", this); fHelper2->SetValue (fVals.spread_amount_y);
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper1; delete fHelper2;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		fFilter->SetValue (&fVals);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Sl1 ':	value = message->FindInt32 ("be:value"); if (value != fVals.spread_amount_x) { fVals.spread_amount_x = value; DoPreview (); } break;
		case 'Sl2 ':	value = message->FindInt32 ("be:value"); if (value != fVals.spread_amount_y) { fVals.spread_amount_y = value; DoPreview (); } break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); spvals = fVals;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[5], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_FLOAT; inputParms[3].data.d_float = ((const SpreadValues *)values)->spread_amount_x;
	inputParms[4].type = PARAM_FLOAT; inputParms[4].data.d_float = ((const SpreadValues *)values)->spread_amount_y;
	(*PLUG_IN_INFO.run_proc) (fName, 5, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				SpreadValues	tmpValues;
				memcpy (&tmpValues, fData, sizeof (SpreadValues));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(SpreadValues)]; fDataSize = sizeof (SpreadValues);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (SpreadValues *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(SpreadValues));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

