#!/bin/sh
#
# A small script to help run example apps
#

prefix=/usr/local
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
classpath=${prefix}/share/java/gconf2.9-2.9.2.jar

GCONFJAVA_LIB=$libdir
GCONFJAVA_JAR=$classpath

# You should not need to modify anything below here

error_message ()
{
	echo
	echo
	echo "Usage: ./runExample.sh CLASSNAME [ARGS]"
		echo "Please first ensure you have a valid java interpreter and compiler" 
	echo "in your \$PATH and you have compiled java-gnome libraries and jars, then" 
	echo "run an application by passing it's classname to this script, e.g.:"
	echo
	echo "$0 progressbar/ProgressBarTest"
	echo
	exit 1;
}

echo "Java-Gnome Example Application Launcher"
echo

GTKJAVA_JAR=`pkg-config --variable classpath gtk2-java`
if ! test -n "$GTKJAVA_JAR"; then
	echo "Package gtk2-java was not found in the pkg-config search path."
	echo "Perhaps you should add the directory containing 'gtk2-java.pc'"
	echo "to the PKG_CONFIG_PATH environment variable"
	echo "No package 'gtk2-java' found"
	exit 1
fi

GTKJAVA_LIB=`pkg-config --variable libdir gtk2-java`
if ! test -n "$GTKJAVA_LIB"; then
	echo "Library requirements (gtk+-2.0 >= 2.4) not met;"
	echo "consider adjusting the PKG_CONFIG_PATH environment" 
	echo "variable if your libraries are in a nonstandard prefix" 
	echo "so pkg-config can find them."
	exit 1
fi

GNOMEJAVA_JAR=`pkg-config --variable classpath gnome2-java`
if ! test -n "$GNOMEJAVA_JAR"; then
	echo "Package gnome2-java was not found in the pkg-config search path."
	echo "Perhaps you should add the directory containing 'gnome2-java.pc'"
	echo "to the PKG_CONFIG_PATH environment variable"
	echo "No package 'gnome2-java' found"
	exit 1
fi

GNOMEJAVA_LIB=`pkg-config --variable libdir gnome2-java`
if ! test -n "$GNOMEJAVA_LIB"; then
	echo "Library requirements (libgnomejava2.8) not met;"
	echo "consider adjusting the PKG_CONFIG_PATH environment" 
	echo "variable if your libraries are in a nonstandard prefix" 
	echo "so pkg-config can find them."
	exit 1
fi

NEED_LIB="$GTKJAVA_LIB $GNOMEJAVA_LIB $GCONFJAVA_LIB"
NEED_JAR="$GTKJAVA_JAR $GNOMEJAVA_JAR $GCONFJAVA_JAR"

echo "Checking for jvm and compiler availability..."

#Try to use gcj first, then javac
if [ `which gcj 2> /dev/null` ]; then
	JAVAC="gcj -C"
elif [ `which javac 2> /dev/null` ]; then
	JAVAC=javac
else
	echo "ERROR: no valid compiler was found in your \$PATH"
	error_message
fi

#Try to use gij first, then java
if [ `which gij 2> /dev/null` ]; then
	JAVA=gij
elif [ `which java 2> /dev/null` ]; then
	JAVA=java
else
	echo "ERROR: no valid interpreter was found in your \$PATH"
	error_message
fi

echo "	`echo $JAVAC | awk '{print $1}'` and $JAVA - appear to be ok"

#Praise the users who use Free Software
if [ "$JAVAC" == "gcj -C" -a "$JAVA" == "gij" ]; then
	echo
	echo "	You are using Open Source java" 
	echo "	virtual machine and compiler: this is so good!"
fi

echo
echo "Checking if library paths exist..."

for NEEDLIB in $NEED_LIB; do
	if test -e $NEEDLIB; then echo "	$NEEDLIB - appears to be ok"; fi;
	if ! test -e $NEEDLIB; then echo "	$NEEDLIB - DOES NOT EXIST" && error_message; fi;
done;

echo
echo "Testing JAR archives..."
for JAR in $NEED_JAR; do
	if test -e $JAR; then
		echo "	$JAR - appears to be ok";
	else
		echo "	$JAR - DOES NOT EXIST";
	error_message
	fi;
done;

echo

if ! test -e $1.java ; then
	echo "ERROR: unexpected example app";
	echo
	error_message
fi

#do the real work
export CLASSPATH=.:$CLASSPATH:`echo $NEED_JAR | sed s'/ /:/g'`
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:`echo $NEED_LIB | sed s'/ /:/g'`

($JAVAC $1.java && echo "Compilation successful") || (echo "ERROR: Compilation failed"; error_message)

TARGET=`echo $1 | sed 's/\//\./g'`
shift
($JAVA $TARGET $@ && echo "Application successfully terminated") || (echo
"Application terminated abnormally"; error_message)
