/*Class for communicating with the sz program*/

#include <src/Szwrapper.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "src/MoUtils.h"




struct _moserialSzwrapperPrivate {
	moserialSzwrapperProtocol _protocol;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	char* _filename;
};

#define MOSERIAL_SZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperPrivate))
enum  {
	MOSERIAL_SZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_SZWRAPPER_PROTOCOL,
	MOSERIAL_SZWRAPPER_FILENAME
};
static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self);
static void moserial_szwrapper_shutdown (moserialSzwrapper* self);
static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value);
static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const char* value);
static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_szwrapper_parent_class = NULL;
static void moserial_szwrapper_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType moserial_szwrapper_protocol_get_type (void) {
	static GType moserial_szwrapper_protocol_type_id = 0;
	if (G_UNLIKELY (moserial_szwrapper_protocol_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_RAW, "MOSERIAL_SZWRAPPER_PROTOCOL_RAW", "raw"}, {MOSERIAL_SZWRAPPER_PROTOCOL_NULL, "MOSERIAL_SZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		moserial_szwrapper_protocol_type_id = g_enum_register_static ("moserialSzwrapperProtocol", values);
	}
	return moserial_szwrapper_protocol_type_id;
}


moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename) {
	GParameter * __params;
	GParameter * __params_it;
	moserialSzwrapper * self;
	moserialSerialConnection* _tmp1;
	moserialSerialConnection* _tmp0;
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "protocol";
	g_value_init (&__params_it->value, MOSERIAL_SZWRAPPER_TYPE_PROTOCOL);
	g_value_set_enum (&__params_it->value, *protocol);
	__params_it++;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, filename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->sc = (_tmp1 = (_tmp0 = sc, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->sc == NULL) ? NULL : (self->sc = (g_object_unref (self->sc), NULL)), _tmp1);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename) {
	return moserial_szwrapper_construct (MOSERIAL_TYPE_SZWRAPPER, protocol, sc, filename);
}


void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->running) {
		gsize bytesWritten;
		gchar* _tmp0;
		gint b_size;
		gint b_length1;
		gchar* b;
		bytesWritten = 0UL;
		_tmp0 = NULL;
		b = (_tmp0 = g_new0 (gchar, 1), b_length1 = 1, b_size = b_length1, _tmp0);
		b[0] = (gchar) byte;
		{
			if (self->running) {
				g_io_channel_write_chars (self->priv->IOChannelInput, b, b_length1, &bytesWritten, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_IO_CHANNEL_ERROR) {
						goto __catch17_g_io_channel_error;
					}
					if (inner_error->domain == G_CONVERT_ERROR) {
						goto __catch17_g_convert_error;
					}
					goto __finally17;
				}
			}
			if (self->running) {
				g_io_channel_flush (self->priv->IOChannelInput, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_IO_CHANNEL_ERROR) {
						goto __catch17_g_io_channel_error;
					}
					if (inner_error->domain == G_CONVERT_ERROR) {
						goto __catch17_g_convert_error;
					}
					goto __finally17;
				}
			}
		}
		goto __finally17;
		__catch17_g_io_channel_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				moserial_szwrapper_shutdown (self);
				fprintf (stdout, "writeChar() %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		goto __finally17;
		__catch17_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally17:
		if (inner_error != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		b = (g_free (b), NULL);
	}
}


static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self) {
	return moserial_szwrapper_shutdown_timeout (self);
}


static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	inner_error = NULL;
	while (TRUE) {
		gboolean _tmp0;
		_tmp0 = FALSE;
		if (gtk_events_pending ()) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = gdk_events_pending ();
		}
		if (!_tmp0) {
			break;
		}
		gtk_main_iteration_do (TRUE);
	}
	if (self->running) {
		gchar* _tmp1;
		gint m_buf_size;
		gint m_buf_length1;
		gchar* m_buf;
		char* messages;
		char* message;
		gsize bytesRead;
		char* _tmp6;
		gboolean _tmp7;
		_tmp1 = NULL;
		m_buf = (_tmp1 = g_new0 (gchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp1);
		messages = g_strdup ("");
		message = g_strdup ("");
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			gboolean _tmp2;
			return (_tmp2 = TRUE, m_buf = (g_free (m_buf), NULL), messages = (g_free (messages), NULL), message = (g_free (message), NULL), _tmp2);
		}
		{
			g_io_channel_read_chars (source, m_buf, m_buf_length1, &bytesRead, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_CONVERT_ERROR) {
					goto __catch18_g_convert_error;
				}
				goto __finally18;
			}
		}
		goto __finally18;
		__catch18_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally18:
		if (inner_error != NULL) {
			m_buf = (g_free (m_buf), NULL);
			messages = (g_free (messages), NULL);
			message = (g_free (message), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			for (; x < bytesRead; x++) {
				gunichar c;
				gboolean _tmp3;
				c = (gunichar) m_buf[x];
				_tmp3 = FALSE;
				if (g_unichar_isprint (c)) {
					_tmp3 = TRUE;
				} else {
					_tmp3 = g_unichar_isspace (c);
				}
				if (_tmp3) {
					char* _tmp5;
					char* _tmp4;
					_tmp5 = NULL;
					_tmp4 = NULL;
					messages = (_tmp5 = g_strconcat (messages, _tmp4 = g_strdup_printf ("%c", (gint) m_buf[x]), NULL), messages = (g_free (messages), NULL), _tmp5);
					_tmp4 = (g_free (_tmp4), NULL);
				}
			}
		}
		_tmp6 = NULL;
		message = (_tmp6 = mo_utils_getLastMessage (messages), message = (g_free (message), NULL), _tmp6);
		if (!(_vala_strcmp0 (message, "") == 0)) {
			g_signal_emit_by_name (self, "update-status", message);
		}
		if (!(strstr (messages, "Transfer complete") == NULL)) {
			g_timeout_add ((guint) 2000, _moserial_szwrapper_shutdown_timeout_gsource_func, self);
		}
		/*Wait 2 seconds for for the final remote packet to get ackd
		shutdown();*/
		if (!(strstr (messages, "Transfer incomplete") == NULL)) {
			moserial_szwrapper_shutdown (self);
		}
		return (_tmp7 = TRUE, m_buf = (g_free (m_buf), NULL), messages = (g_free (messages), NULL), message = (g_free (message), NULL), _tmp7);
	} else {
		return FALSE;
	}
}


void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	/*send cancel string to remote client and rz*/
	if (self->running) {
		gboolean _tmp0;
		gboolean _tmp1;
		gboolean _tmp2;
		gboolean _tmp3;
		g_signal_emit_by_name (self, "update-status", _ ("canceled"));
		_tmp0 = FALSE;
		_tmp1 = FALSE;
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp1) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
		}
		if (_tmp0) {
			{
				gint x;
				x = 0;
				for (; x < 20; x++) {
					if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM) {
						moserial_serial_connection_sendByte (self->sc, (guchar) ('X' & 037));
						moserial_szwrapper_writeChar (self, (guchar) ('X' & 037));
					} else {
						moserial_serial_connection_sendByte (self->sc, (guchar) 0x18);
					}
				}
			}
		}
		_tmp2 = FALSE;
		_tmp3 = FALSE;
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp3 = TRUE;
		} else {
			_tmp3 = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp3) {
			_tmp2 = TRUE;
		} else {
			_tmp2 = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
		}
		if (_tmp2) {
			moserial_szwrapper_shutdown (self);
		}
	}
}


static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_szwrapper_shutdown (self);
	return FALSE;
}


static void moserial_szwrapper_shutdown (moserialSzwrapper* self) {
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	inner_error = NULL;
	while (TRUE) {
		gboolean _tmp0;
		_tmp0 = FALSE;
		if (gtk_events_pending ()) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = gdk_events_pending ();
		}
		if (!_tmp0) {
			break;
		}
		gtk_main_iteration_do (TRUE);
	}
	if (self->running) {
		gchar* _tmp1;
		gint m_buf_size;
		gint m_buf_length1;
		gchar* m_buf;
		gsize bytesRead;
		gboolean _tmp3;
		_tmp1 = NULL;
		m_buf = (_tmp1 = g_new0 (gchar, 1024), m_buf_length1 = 1024, m_buf_size = m_buf_length1, _tmp1);
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			gboolean _tmp2;
			return (_tmp2 = TRUE, m_buf = (g_free (m_buf), NULL), _tmp2);
		}
		{
			g_io_channel_read_chars (source, m_buf, m_buf_length1, &bytesRead, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_CONVERT_ERROR) {
					goto __catch19_g_convert_error;
				}
				goto __finally19;
			}
		}
		goto __finally19;
		__catch19_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally19:
		if (inner_error != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		moserial_serial_connection_sendBytes (self->sc, m_buf, m_buf_length1, bytesRead);
		return (_tmp3 = TRUE, m_buf = (g_free (m_buf), NULL), _tmp3);
	} else {
		return FALSE;
	}
}


moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_protocol;
}


static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value) {
	g_return_if_fail (self != NULL);
	self->priv->_protocol = value;
	g_object_notify ((GObject *) self, "protocol");
}


const char* moserial_szwrapper_get_filename (moserialSzwrapper* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_filename;
}


static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_filename = (g_free (self->priv->_filename), NULL), _tmp2);
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_szwrapper_readBytes (self, source, condition);
}


static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_szwrapper_readError (self, source, condition);
}


static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialSzwrapperClass * klass;
	GObjectClass * parent_class;
	moserialSzwrapper * self;
	GError * inner_error;
	klass = MOSERIAL_SZWRAPPER_CLASS (g_type_class_peek (MOSERIAL_TYPE_SZWRAPPER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SZWRAPPER (obj);
	inner_error = NULL;
	{
		gboolean _tmp0;
		_tmp0 = FALSE;
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_NULL) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = self->priv->_filename == NULL;
		}
		if (_tmp0) {
			self->running = FALSE;
		} else {
			gint argv_size;
			gint argv_length1;
			char** argv;
			gint output;
			gint error;
			gint input;
			argv = (argv_length1 = 0, NULL);
			if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_RAW) {
				char** _tmp1;
				char* _tmp2;
				char* _tmp4;
				const char* _tmp3;
				_tmp1 = NULL;
				argv = (_tmp1 = g_new0 (char*, 2 + 1), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 2, argv_size = argv_length1, _tmp1);
				_tmp2 = NULL;
				argv[0] = (_tmp2 = g_strdup ("cat"), argv[0] = (g_free (argv[0]), NULL), _tmp2);
				_tmp4 = NULL;
				_tmp3 = NULL;
				argv[1] = (_tmp4 = (_tmp3 = self->priv->_filename, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), argv[1] = (g_free (argv[1]), NULL), _tmp4);
			} else {
				char** _tmp5;
				char* _tmp6;
				char* _tmp10;
				char* _tmp12;
				const char* _tmp11;
				_tmp5 = NULL;
				argv = (_tmp5 = g_new0 (char*, 4 + 1), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 4, argv_size = argv_length1, _tmp5);
				_tmp6 = NULL;
				argv[0] = (_tmp6 = g_strdup ("sz"), argv[0] = (g_free (argv[0]), NULL), _tmp6);
				switch (self->priv->_protocol) {
					case MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM:
					{
						char* _tmp7;
						_tmp7 = NULL;
						argv[1] = (_tmp7 = g_strdup ("--xmodem"), argv[1] = (g_free (argv[1]), NULL), _tmp7);
						break;
					}
					case MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM:
					{
						char* _tmp8;
						_tmp8 = NULL;
						argv[1] = (_tmp8 = g_strdup ("--ymodem"), argv[1] = (g_free (argv[1]), NULL), _tmp8);
						break;
					}
					default:
					{
						char* _tmp9;
						_tmp9 = NULL;
						argv[1] = (_tmp9 = g_strdup ("--zmodem"), argv[1] = (g_free (argv[1]), NULL), _tmp9);
						break;
					}
				}
				_tmp10 = NULL;
				argv[2] = (_tmp10 = g_strdup ("-vv"), argv[2] = (g_free (argv[2]), NULL), _tmp10);
				_tmp12 = NULL;
				_tmp11 = NULL;
				argv[3] = (_tmp12 = (_tmp11 = self->priv->_filename, (_tmp11 == NULL) ? NULL : g_strdup (_tmp11)), argv[3] = (g_free (argv[3]), NULL), _tmp12);
			}
			output = 0;
			error = 0;
			input = 0;
			{
				GIOChannel* _tmp13;
				GIOChannel* _tmp14;
				GIOChannel* _tmp15;
				g_spawn_async_with_pipes (NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &self->priv->pid, &input, &output, &error, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				_tmp13 = NULL;
				self->priv->IOChannelOutput = (_tmp13 = g_io_channel_unix_new (output), (self->priv->IOChannelOutput == NULL) ? NULL : (self->priv->IOChannelOutput = (g_io_channel_unref (self->priv->IOChannelOutput), NULL)), _tmp13);
				_tmp14 = NULL;
				self->priv->IOChannelInput = (_tmp14 = g_io_channel_unix_new (input), (self->priv->IOChannelInput == NULL) ? NULL : (self->priv->IOChannelInput = (g_io_channel_unref (self->priv->IOChannelInput), NULL)), _tmp14);
				_tmp15 = NULL;
				self->priv->IOChannelError = (_tmp15 = g_io_channel_unix_new (error), (self->priv->IOChannelError == NULL) ? NULL : (self->priv->IOChannelError = (g_io_channel_unref (self->priv->IOChannelError), NULL)), _tmp15);
				g_io_channel_set_encoding (self->priv->IOChannelOutput, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				g_io_channel_set_flags (self->priv->IOChannelOutput, G_IO_FLAG_NONBLOCK, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				g_io_channel_set_encoding (self->priv->IOChannelError, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				g_io_channel_set_flags (self->priv->IOChannelError, G_IO_FLAG_NONBLOCK, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				g_io_channel_set_encoding (self->priv->IOChannelInput, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch20_g_spawn_error;
					}
					goto __finally20;
				}
				/*IOChannelInput.set_flags(GLib.IOFlags.NONBLOCK);*/
				self->priv->outputChannelId = g_io_add_watch (self->priv->IOChannelOutput, G_IO_IN, _moserial_szwrapper_readBytes_gio_func, self);
				self->priv->errorChannelId = g_io_add_watch (self->priv->IOChannelError, G_IO_IN, _moserial_szwrapper_readError_gio_func, self);
				self->running = TRUE;
			}
			goto __finally20;
			__catch20_g_spawn_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					char* _tmp16;
					GtkMessageDialog* _tmp17;
					GtkMessageDialog* errorDialog;
					self->running = FALSE;
					fprintf (stdout, "spawn error: %s\n", e->message);
					_tmp16 = NULL;
					_tmp17 = NULL;
					errorDialog = (_tmp17 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp16 = g_strdup_printf ("%s", e->message), NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
					gtk_dialog_run ((GtkDialog*) errorDialog);
					gtk_object_destroy ((GtkObject*) errorDialog);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
					(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
				}
			}
			__finally20:
			if (inner_error != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	return obj;
}


static void moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	gpointer boxed;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_szwrapper_get_protocol (self));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_szwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		moserial_szwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		moserial_szwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_szwrapper_class_init (moserialSzwrapperClass * klass) {
	moserial_szwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_szwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_szwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_szwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_szwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_SZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_szwrapper_instance_init (moserialSzwrapper * self) {
	self->priv = MOSERIAL_SZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_szwrapper_finalize (GObject* obj) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (obj);
	(self->sc == NULL) ? NULL : (self->sc = (g_object_unref (self->sc), NULL));
	(self->priv->IOChannelInput == NULL) ? NULL : (self->priv->IOChannelInput = (g_io_channel_unref (self->priv->IOChannelInput), NULL));
	(self->priv->IOChannelOutput == NULL) ? NULL : (self->priv->IOChannelOutput = (g_io_channel_unref (self->priv->IOChannelOutput), NULL));
	(self->priv->IOChannelError == NULL) ? NULL : (self->priv->IOChannelError = (g_io_channel_unref (self->priv->IOChannelError), NULL));
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	G_OBJECT_CLASS (moserial_szwrapper_parent_class)->finalize (obj);
}


GType moserial_szwrapper_get_type (void) {
	static GType moserial_szwrapper_type_id = 0;
	if (moserial_szwrapper_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_szwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSzwrapper), 0, (GInstanceInitFunc) moserial_szwrapper_instance_init, NULL };
		moserial_szwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSzwrapper", &g_define_type_info, 0);
	}
	return moserial_szwrapper_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




