/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 BayLibre, SAS
 * Author: Fabien Parent <fparent@baylibre.com>
 */

#ifndef __MFD_MT6357_CORE_H__
#define __MFD_MT6357_CORE_H__

enum mt6357_irq_top_status_shift {
	MT6357_BUCK_TOP = 0,
	MT6357_LDO_TOP,
	MT6357_PSC_TOP,
	MT6357_SCK_TOP,
	MT6357_BM_TOP,
	MT6357_HK_TOP,
	MT6357_XPP_TOP,
	MT6357_AUD_TOP,
	MT6357_MISC_TOP,
};

enum mt6357_irq_numbers {
	MT6357_IRQ_VPROC_OC = 0,
	MT6357_IRQ_VCORE_OC,
	MT6357_IRQ_VMODEM_OC,
	MT6357_IRQ_VS1_OC,
	MT6357_IRQ_VPA_OC,
	MT6357_IRQ_VCORE_PREOC,
	MT6357_IRQ_VFE28_OC = 16,
	MT6357_IRQ_VXO22_OC,
	MT6357_IRQ_VRF18_OC,
	MT6357_IRQ_VRF12_OC,
	MT6357_IRQ_VEFUSE_OC,
	MT6357_IRQ_VCN33_OC,
	MT6357_IRQ_VCN28_OC,
	MT6357_IRQ_VCN18_OC,
	MT6357_IRQ_VCAMA_OC,
	MT6357_IRQ_VCAMD_OC,
	MT6357_IRQ_VCAMIO_OC,
	MT6357_IRQ_VLDO28_OC,
	MT6357_IRQ_VUSB33_OC,
	MT6357_IRQ_VAUX18_OC,
	MT6357_IRQ_VAUD28_OC,
	MT6357_IRQ_VIO28_OC,
	MT6357_IRQ_VIO18_OC,
	MT6357_IRQ_VSRAM_PROC_OC,
	MT6357_IRQ_VSRAM_OTHERS_OC,
	MT6357_IRQ_VIBR_OC,
	MT6357_IRQ_VDRAM_OC,
	MT6357_IRQ_VMC_OC,
	MT6357_IRQ_VMCH_OC,
	MT6357_IRQ_VEMC_OC,
	MT6357_IRQ_VSIM1_OC,
	MT6357_IRQ_VSIM2_OC,
	MT6357_IRQ_PWRKEY = 48,
	MT6357_IRQ_HOMEKEY,
	MT6357_IRQ_PWRKEY_R,
	MT6357_IRQ_HOMEKEY_R,
	MT6357_IRQ_NI_LBAT_INT,
	MT6357_IRQ_CHRDET,
	MT6357_IRQ_CHRDET_EDGE,
	MT6357_IRQ_VCDT_HV_DET,
	MT6357_IRQ_WATCHDOG,
	MT6357_IRQ_VBATON_UNDET,
	MT6357_IRQ_BVALID_DET,
	MT6357_IRQ_OV,
	MT6357_IRQ_RTC = 64,
	MT6357_IRQ_FG_BAT0_H = 80,
	MT6357_IRQ_FG_BAT0_L,
	MT6357_IRQ_FG_CUR_H,
	MT6357_IRQ_FG_CUR_L,
	MT6357_IRQ_FG_ZCV,
	MT6357_IRQ_BATON_LV = 96,
	MT6357_IRQ_BATON_HT,
	MT6357_IRQ_BAT_H = 112,
	MT6357_IRQ_BAT_L,
	MT6357_IRQ_AUXADC_IMP,
	MT6357_IRQ_NAG_C_DLTV,
	MT6357_IRQ_AUDIO = 128,
	MT6357_IRQ_ACCDET = 133,
	MT6357_IRQ_ACCDET_EINT0,
	MT6357_IRQ_ACCDET_EINT1,
	MT6357_IRQ_SPI_CMD_ALERT = 144,
	MT6357_IRQ_NR,
};

#define MT6357_IRQ_BUCK_BASE	MT6357_IRQ_VPROC_OC
#define MT6357_IRQ_LDO_BASE	MT6357_IRQ_VFE28_OC
#define MT6357_IRQ_PSC_BASE	MT6357_IRQ_PWRKEY
#define MT6357_IRQ_SCK_BASE	MT6357_IRQ_RTC
#define MT6357_IRQ_BM_BASE	MT6357_IRQ_FG_BAT0_H
#define MT6357_IRQ_HK_BASE	MT6357_IRQ_BAT_H
#define MT6357_IRQ_AUD_BASE	MT6357_IRQ_AUDIO
#define MT6357_IRQ_MISC_BASE	MT6357_IRQ_SPI_CMD_ALERT

#define MT6357_IRQ_BUCK_BITS (MT6357_IRQ_VCORE_PREOC - MT6357_IRQ_BUCK_BASE + 1)
#define MT6357_IRQ_LDO_BITS (MT6357_IRQ_VSIM2_OC - MT6357_IRQ_LDO_BASE + 1)
#define MT6357_IRQ_PSC_BITS (MT6357_IRQ_VCDT_HV_DET - MT6357_IRQ_PSC_BASE + 1)
#define MT6357_IRQ_SCK_BITS (MT6357_IRQ_RTC - MT6357_IRQ_SCK_BASE + 1)
#define MT6357_IRQ_BM_BITS (MT6357_IRQ_BATON_HT - MT6357_IRQ_BM_BASE + 1)
#define MT6357_IRQ_HK_BITS (MT6357_IRQ_NAG_C_DLTV - MT6357_IRQ_HK_BASE + 1)
#define MT6357_IRQ_AUD_BITS (MT6357_IRQ_ACCDET_EINT1 - MT6357_IRQ_AUD_BASE + 1)
#define MT6357_IRQ_MISC_BITS	\
	(MT6357_IRQ_SPI_CMD_ALERT - MT6357_IRQ_MISC_BASE + 1)

#define MT6357_TOP_GEN(sp)	\
{	\
	.hwirq_base = MT6357_IRQ_##sp##_BASE,	\
	.num_int_regs =	\
		((MT6357_IRQ_##sp##_BITS - 1) /	\
		MTK_PMIC_REG_WIDTH) + 1,	\
	.en_reg = MT6357_##sp##_TOP_INT_CON0,	\
	.en_reg_shift = 0x6,	\
	.sta_reg = MT6357_##sp##_TOP_INT_STATUS0,	\
	.sta_reg_shift = 0x2,	\
	.top_offset = MT6357_##sp##_TOP,	\
}

#endif /* __MFD_MT6357_CORE_H__ */
