<?xml version="1.0" encoding="UTF-8" ?>
<!--
<comment>
		****************
		(C) 2005, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl" xmlns:atom="http://www.w3.org/2005/Atom">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:template match="/">
		<atom:feed>
				<atom:title>Recent Entries: <xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/</atom:title>
				<atom:subtitle>Entries: <xsl:value-of select="/results/row[1]/total"/> Views: <xsl:value-of select="/results/row[1]/hits"/></atom:subtitle>
				<atom:link rel="alternate" type="text/html" href="{$param/results/row[setting='WWWHOSTNAME']/value}forum/"/>
				<atom:link rel="self" type="application/atom+xml" href="{$param/results/row[setting='WWWHOSTNAME']/value}forum/atom/recent/1" />
				<atom:id><xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/topic/<xsl:value-of select="/results/row/topicnumber"/></atom:id>
				<atom:updated><xsl:for-each select="results/row[1]"><xsl:value-of select="dateYear"/>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateMonth"/></xsl:call-template>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateDayOfMonth"/></xsl:call-template>T<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template>:00Z</xsl:for-each></atom:updated>
				<atom:generator>1060 NetKernel Standard Edition - http://www.1060research.com</atom:generator>
				<xsl:apply-templates select="results/row"/>
		</atom:feed>
    </xsl:template>
	
	<!--
	///////////////////////
	//Match each entry item
	///////////////////////
	-->
	<xsl:template match="row">
		<atom:entry>
			<atom:title>
				<xsl:choose>
					<xsl:when test="title=''">untitled entry</xsl:when>
					<xsl:otherwise><xsl:value-of select="title"/></xsl:otherwise>
				</xsl:choose>
			</atom:title>
			<atom:link rel="alternate" type="text/html" href="{$param/results/row[setting='WWWHOSTNAME']/value}forum/entry/{id}" />
			<atom:id><xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/entry/<xsl:value-of select="id"/></atom:id>
			<atom:published><xsl:value-of select="dateYear"/>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateMonth"/></xsl:call-template>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateDayOfMonth"/></xsl:call-template>T<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template>:00Z</atom:published>
			<atom:updated><xsl:value-of select="dateYear"/>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateMonth"/></xsl:call-template>-<xsl:call-template name="addzero"><xsl:with-param name="n" select="dateDayOfMonth"/></xsl:call-template>T<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template>:00Z</atom:updated>
			<atom:summary><xsl:value-of select="substring(entry/*, 0 , 100)"/>...</atom:summary>
			<atom:author><atom:name><xsl:value-of select="userid"/></atom:name></atom:author>
			<atom:content type="xhtml" xml:lang="en" xml:base="{$param/results/row[setting='WWWHOSTNAME']/value}forum/entry/{id}">
				<div xmlns="http://www.w3.org/1999/xhtml">
				<xsl:copy-of select="entry/*"/>
				</div>
			</atom:content>
		</atom:entry>
	</xsl:template>
	
	<xsl:template name="toText">
		<xsl:param name="entry"/>
		<xsl:param name="text"/>
		<xsl:if test="string-length($text) &lt; 100 and descendant::*">
			<xsl:call-template name="toText">
				<xsl:with-param name="entry" select="descendant::*"/>
				<xsl:with-param name="text" select="concat($text,' ', $entry/text())"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$text"/>
	</xsl:template>
		
	<!--
	//////////////////////////////////////////////
	//Utility to add Zero to a number less than 10
	//////////////////////////////////////////////
	-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
</xsl:stylesheet>