<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in complience with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="/nvp">
		<xsl:variable name="blogid" select="blogid"/>
        <batch>
			<sql>
				SELECT @membergroupid:=id from blogxter.groups where name='member';
			</sql>
			<xsl:for-each select="item">
				<xsl:choose>
					<xsl:when test="substring-before(.,',')='accept'">
						<sql>
							INSERT INTO affiliations VALUES (<xsl:value-of select="substring-after(.,',')"/> , @membergroupid, <xsl:value-of select="$blogid"/> , 'approved');
						</sql>
						<sql>
							SELECT @ticketid:=id FROM tickets WHERE userid=<xsl:value-of select="substring-after(.,',')"/> AND type='BLOGREQ' AND value=<xsl:value-of select="$blogid"/>;
						</sql>
						<sql>
							DELETE FROM messages WHERE userid=<xsl:value-of select="substring-after(.,',')"/> AND restype='TICKET' AND resid=@ticketid;
						</sql>
						<sql>
							DELETE FROM tickets WHERE userid=<xsl:value-of select="substring-after(.,',')"/> AND type='BLOGREQ' AND value=<xsl:value-of select="$blogid"/>;
						</sql>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="reject">
				<sql>
				SELECT @ticketid:=id FROM tickets WHERE userid=<xsl:value-of select="."/> AND type='BLOGREQ' AND value=<xsl:value-of select="$blogid"/>;
				</sql>
				<sql>
				DELETE FROM messages WHERE userid=<xsl:value-of select="."/> AND restype='TICKET' AND resid=@ticketid;
				</sql>
				<sql>
				DELETE FROM tickets WHERE userid=<xsl:value-of select="."/> AND type='BLOGREQ' AND value=<xsl:value-of select="$blogid"/>;
				</sql>
			</xsl:for-each>
		</batch>
    </xsl:template>

</xsl:stylesheet> 
