<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in complience with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/nvp">
		<batch>
			<!--Get blogid-->
			<sql>
				SELECT @entryid:=entries.id FROM entries WHERE 
				entries.publicid='<xsl:value-of select="publicid"/>'	;
			</sql>
			<!--Create new comment-->
			<xsl:if test="comments > 0">
				<sql>
					INSERT INTO comments VALUES (null, @entryid, '<xsl:value-of select="name"/>' , '<xsl:value-of select="email"/>','<xsl:value-of select="web"/>', NOW(), '<xsl:value-of select="title"/>', '<xsl:value-of select="comment"/>', 
					<xsl:choose>
						<xsl:when test="comments = 1">
						'approved'
						</xsl:when>
						<xsl:when test="comments = 2">
						'pending'
						</xsl:when>
					</xsl:choose>
					);
				</sql>
			</xsl:if>
		</batch>
    </xsl:template>

</xsl:stylesheet> 
