<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in complience with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/results">
        <email>
			<xsl:for-each select="row">
				<to><xsl:value-of select="email"/></to>
			</xsl:for-each>
			<subject>New Blog Entry: <xsl:value-of select="$param/meta/blog/nvp/name"/></subject>
			<message>
				<html>
				<h1>New Entry in Blog: <xsl:value-of select="$param/meta/blog/nvp/name"/></h1>
				<h2><xsl:value-of select="$param/meta/entry/blog/item/title"/></h2>
				<p>
					<xsl:value-of select="$param/meta/entry/blog/item/summary"/>
				</p>
				<p>
				<a>
					<xsl:attribute name="href">
						http://<xsl:value-of select="$param/meta/blog/nvp/hostname"/>/blogxter/entry?publicid=<xsl:value-of select="$param/meta/entry/blog/item/publicid"/>
					</xsl:attribute>
					link
				</a>
				</p>
				</html>
			</message>
		</email>
    </xsl:template>

</xsl:stylesheet> 
